/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheListener;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeNotExistsException;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticNodeInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;

    @Override
    public void setCache(CacheSPI c) {
        super.setCache(c);
        this.nodeFactory = c.getConfiguration().getRuntimeConfig().getNodeFactory();
    }

    @Override
    public Object invoke(MethodCall m) throws Throwable {
        if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
            return super.invoke(m);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Processing method call " + (Object)((Object)m)));
        }
        InvocationContext ctx = this.cache.getInvocationContext();
        Object[] args = m.getArgs();
        Object result = null;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        if (36 == m.getMethodId()) {
            WorkspaceNode parent;
            if (ctx.getOptionOverrides().getDataVersion() != null && ctx.isOriginLocal()) {
                throw new CacheException("Setting a data version while performing a move() is not supported!!");
            }
            Fqn parentFqn = (Fqn)args[1];
            Fqn nodeFqn = (Fqn)args[0];
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Adding nodes " + parentFqn + " and " + nodeFqn + " to the workspace."));
            }
            if ((parent = this.getOrCreateWorkspaceNode(parentFqn, workspace, false)) == null) {
                throw new NodeNotExistsException("Node " + parentFqn + " does not exist!");
            }
            WorkspaceNode node = this.getOrCreateWorkspaceNode(nodeFqn, workspace, true);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Parent: " + parent));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Node: " + node));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Workspace snapshot: " + workspace));
            }
            this.greedyGetNodes(node, workspace);
            this.doMove(parent, node, workspace);
            this.addToModificationList(gtx, m);
        } else if (MethodDeclarations.isCrudMethod(m.getMethodId())) {
            Fqn fqn = this.getFqn(args);
            WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, true);
            if (workspaceNode == null && m.getMethodId() == 34) {
                workspaceNode = this.getOrCreateWorkspaceNode(this.getBackupFqn(args), workspace, true);
            }
            if (workspaceNode != null) {
                if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                    workspace.setVersioningImplicit(false);
                    DataVersion version = ctx.getOptionOverrides().getDataVersion();
                    workspaceNode.setVersion(version);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to explicit"));
                    }
                    workspaceNode.setVersioningImplicit(false);
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Setting versioning for node " + workspaceNode.getFqn() + " to implicit"));
                    }
                    workspaceNode.setVersioningImplicit(true);
                }
            } else if ((ctx.getOptionOverrides() == null || !ctx.getOptionOverrides().isFailSilently()) && MethodDeclarations.isPutMethod(m.getMethodId())) {
                throw new CacheException("Unable to set node version for " + this.getFqn(args) + ", node is null.");
            }
            switch (m.getMethodId()) {
                case 1: {
                    Boolean erase = (Boolean)args[3];
                    this.cache.getNotifier().notifyNodeModified(fqn, true, CacheListener.ModificationType.PUT_MAP, workspaceNode.getData(), false);
                    this.putDataMap((Map)args[2], erase, workspace, workspaceNode);
                    this.cache.getNotifier().notifyNodeModified(fqn, false, CacheListener.ModificationType.PUT_MAP, workspaceNode.getData(), false);
                    break;
                }
                case 2: {
                    this.cache.getNotifier().notifyNodeModified(fqn, true, CacheListener.ModificationType.PUT_MAP, workspaceNode.getData(), false);
                    this.putDataMap((Map)args[2], true, workspace, workspaceNode);
                    this.cache.getNotifier().notifyNodeModified(fqn, false, CacheListener.ModificationType.PUT_MAP, workspaceNode.getData(), false);
                    break;
                }
                case 3: 
                case 45: {
                    Object key = args[2];
                    Object value = args[3];
                    HashMap<Object, Object> addedData = new HashMap<Object, Object>();
                    addedData.put(key, value);
                    this.cache.getNotifier().notifyNodeModified(fqn, true, CacheListener.ModificationType.PUT_DATA, workspaceNode.getData(), false);
                    result = this.putDataKeyValue(key, value, workspace, workspaceNode);
                    this.cache.getNotifier().notifyNodeModified(fqn, false, CacheListener.ModificationType.PUT_DATA, addedData, false);
                    break;
                }
                case 5: {
                    this.cache.getNotifier().notifyNodeRemoved(fqn, true, workspaceNode == null ? null : workspaceNode.getData(), false);
                    result = this.removeNode(workspace, workspaceNode);
                    this.cache.getNotifier().notifyNodeRemoved(fqn, false, null, false);
                    break;
                }
                case 6: {
                    this.cache.getNotifier().notifyNodeModified(fqn, true, CacheListener.ModificationType.REMOVE_DATA, workspaceNode == null ? null : workspaceNode.getData(), false);
                    Object removeKey = args[2];
                    result = this.removeKey(removeKey, workspace, workspaceNode);
                    HashMap<Object, Object> removedData = new HashMap<Object, Object>();
                    removedData.put(removeKey, result);
                    this.cache.getNotifier().notifyNodeModified(fqn, false, CacheListener.ModificationType.REMOVE_DATA, removedData, false);
                    break;
                }
                case 7: {
                    HashMap<Object, Object> data = workspaceNode == null ? null : new HashMap<Object, Object>(workspaceNode.getData());
                    this.cache.getNotifier().notifyNodeModified(fqn, true, CacheListener.ModificationType.REMOVE_DATA, data, false);
                    this.removeData(workspace, workspaceNode);
                    this.cache.getNotifier().notifyNodeModified(fqn, false, CacheListener.ModificationType.REMOVE_DATA, data, false);
                    break;
                }
                case 34: {
                    result = super.invoke(m);
                }
                default: {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info((Object)("Cannot Handle Method " + (Object)((Object)m)));
                }
            }
            this.addToModificationList(gtx, m);
        } else {
            switch (m.getMethodId()) {
                case 26: {
                    result = this.getValueForKey(args, workspace);
                    break;
                }
                case 25: {
                    result = this.getKeys(args, workspace);
                    break;
                }
                case 23: {
                    result = this.getChildNames(args, workspace);
                    break;
                }
                case 31: {
                    result = this.getNode(args, workspace);
                    break;
                }
                default: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("read Method " + (Object)((Object)m) + " called - don't know how to handle, passing on!"));
                    }
                    result = super.invoke(m);
                }
            }
        }
        return result;
    }

    private Fqn getBackupFqn(Object[] args) {
        return (Fqn)args[2];
    }

    private void addToModificationList(GlobalTransaction gtx, MethodCall m) {
        Option opt = this.cache.getInvocationContext().getOptionOverrides();
        if (opt == null || !opt.isCacheModeLocal()) {
            this.txTable.addModification(gtx, m);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Method " + (Object)((Object)m) + " to modification list"));
            }
        }
        if (this.cache.getCacheLoaderManager() != null) {
            this.txTable.addCacheLoaderModification(gtx, m);
        }
    }

    public void doMove(WorkspaceNode parent, WorkspaceNode node, TransactionWorkspace ws) {
        Fqn nodeFqn = node.getFqn();
        if (nodeFqn.isRoot()) {
            this.log.warn((Object)"Attempting to move the root node.  Not taking any action, treating this as a no-op.");
            return;
        }
        WorkspaceNode oldParent = this.getOrCreateWorkspaceNode(nodeFqn.getParent(), ws, false);
        if (oldParent == null) {
            throw new NodeNotExistsException("Node " + nodeFqn.getParent() + " does not exist!");
        }
        Object nodeName = nodeFqn.getLastElement();
        oldParent.removeChild(new Fqn<Object>(nodeName));
        Fqn<Object> nodeNewFqn = new Fqn<Object>(parent.getFqn(), nodeFqn.getLastElement());
        this.cache.getNotifier().notifyNodeMoved(nodeFqn, nodeNewFqn, true, false);
        this.moveFqns(node, parent.getFqn(), ws);
        this.removeNode(ws, node);
        this.cache.getNotifier().notifyNodeMoved(nodeFqn, nodeNewFqn, false, false);
    }

    private void moveFqns(WorkspaceNode node, Fqn newBase, TransactionWorkspace ws) {
        Fqn<Object> newFqn = new Fqn<Object>(newBase, node.getFqn().getLastElement());
        WorkspaceNode movedNode = this.getOrCreateWorkspaceNode(newFqn, ws, true);
        movedNode.putAll(node.getData());
        for (Object n : node.getChildrenNames()) {
            WorkspaceNode child = this.getOrCreateWorkspaceNode(new Fqn<Object>(node.getFqn(), n), ws, false);
            if (child == null) continue;
            this.moveFqns(child, newFqn, ws);
        }
    }

    protected void greedyGetNodes(WorkspaceNode n, TransactionWorkspace ws) {
        Fqn myFqn = n.getFqn();
        for (Object child : n.getChildrenNames()) {
            Fqn<Object> childFqn = new Fqn<Object>(myFqn, child);
            WorkspaceNode cn = this.getOrCreateWorkspaceNode(childFqn, ws, false);
            if (!ws.hasNode(childFqn)) {
                ws.addNode(cn);
            }
            this.greedyGetNodes(cn, ws);
        }
    }

    private Fqn getFqn(Object[] args) {
        return (Fqn)args[1];
    }

    private void putDataMap(Map<Object, Object> data, boolean eraseExisitng, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return;
        }
        if (eraseExisitng) {
            workspaceNode.clearData();
        }
        workspaceNode.putAll(data);
        workspace.addNode(workspaceNode);
    }

    private Object putDataKeyValue(Object key, Object value, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return null;
        }
        Object old = workspaceNode.put(key, value);
        workspace.addNode(workspaceNode);
        return old;
    }

    private boolean removeNode(TransactionWorkspace workspace, WorkspaceNode workspaceNode) throws CacheException {
        WorkspaceNode toDelete;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeNode " + workspace + " node=" + workspaceNode));
        }
        if (workspaceNode == null) {
            return false;
        }
        boolean debug = this.log.isDebugEnabled();
        Fqn parentFqn = workspaceNode.getFqn().getParent();
        WorkspaceNode parentNode = this.getOrCreateWorkspaceNode(parentFqn, workspace, false);
        if (!(parentNode != null || (parentNode = workspace.getNode(parentFqn)) != null && parentNode.isDeleted())) {
            throw new NodeNotExistsException("Unable to find parent node with Fqn " + parentFqn);
        }
        parentNode.removeChild(new Fqn<Object>(workspaceNode.getFqn().getLastElement()));
        workspace.addNode(parentNode);
        if (debug) {
            this.log.debug((Object)("added parent node " + parentNode.getFqn() + " to workspace"));
        }
        Fqn nodeFqn = workspaceNode.getFqn();
        workspace.addNode(workspaceNode);
        SortedMap tailMap = workspace.getNodesAfter(workspaceNode.getFqn());
        Iterator it = tailMap.entrySet().iterator();
        while (it.hasNext() && (toDelete = it.next().getValue()).getFqn().isChildOrEquals(nodeFqn)) {
            if (debug) {
                this.log.debug((Object)("marking node " + toDelete.getFqn() + " as deleted"));
            }
            toDelete.markAsDeleted(true);
        }
        return true;
    }

    private Object removeKey(Object removeKey, TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return null;
        }
        Object old = workspaceNode.remove(removeKey);
        workspace.addNode(workspaceNode);
        return old;
    }

    private void removeData(TransactionWorkspace workspace, WorkspaceNode workspaceNode) {
        if (workspaceNode == null) {
            return;
        }
        workspaceNode.clearData();
        workspace.addNode(workspaceNode);
    }

    private Object getValueForKey(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        Object key = args[1];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.cache.getNotifier().notifyNodeVisited(fqn, true, false);
        Object val = workspaceNode.get(key);
        workspace.addNode(workspaceNode);
        this.cache.getNotifier().notifyNodeVisited(fqn, false, false);
        return val;
    }

    private Object getNode(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.cache.getNotifier().notifyNodeVisited(fqn, true, false);
        workspace.addNode(workspaceNode);
        this.cache.getNotifier().notifyNodeVisited(fqn, false, false);
        return workspaceNode.getNode();
    }

    private Object getKeys(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.cache.getNotifier().notifyNodeVisited(fqn, true, false);
        Set keySet = workspaceNode.getKeys();
        workspace.addNode(workspaceNode);
        this.cache.getNotifier().notifyNodeVisited(fqn, false, false);
        return keySet;
    }

    private Object getChildNames(Object[] args, TransactionWorkspace workspace) {
        Fqn fqn = (Fqn)args[0];
        WorkspaceNode workspaceNode = this.getOrCreateWorkspaceNode(fqn, workspace, false);
        if (workspaceNode == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("unable to find node " + fqn + " in workspace."));
            }
            return null;
        }
        this.cache.getNotifier().notifyNodeVisited(fqn, true, false);
        Set<Object> nameSet = workspaceNode.getChildrenNames();
        workspace.addNode(workspaceNode);
        this.cache.getNotifier().notifyNodeVisited(fqn, false, false);
        return nameSet;
    }

    private WorkspaceNode getOrCreateWorkspaceNode(Fqn fqn, TransactionWorkspace workspace, boolean undeleteIfNecessary) {
        WorkspaceNode workspaceNode = workspace.getNode(fqn);
        if (workspaceNode == null) {
            NodeSPI node = this.cache.peek(fqn, true);
            if (node == null) {
                return null;
            }
            workspaceNode = this.nodeFactory.createWorkspaceNode(node, workspace);
            workspace.addNode(workspaceNode);
        }
        if (workspaceNode.isDeleted()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Node " + fqn + " has been deleted in the workspace."));
            }
            if (undeleteIfNecessary) {
                workspaceNode.markAsDeleted(false);
                WorkspaceNode parent = this.getOrCreateWorkspaceNode(fqn.getParent(), workspace, true);
                parent.addChild(workspaceNode);
            } else {
                workspaceNode = null;
            }
        }
        if (workspaceNode != null && !(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
            workspaceNode.setVersioningImplicit(false);
        }
        return workspaceNode;
    }
}

