/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;

public class OptimisticReplicationInterceptor
extends BaseRpcInterceptor {
    private Map broadcastTxs = new ConcurrentHashMap();

    public Object invoke(MethodCall m) throws Throwable {
        Object retval;
        block19: {
            block18: {
                if (MethodDeclarations.isBuddyGroupOrganisationMethod(m.getMethodId())) {
                    return super.invoke(m);
                }
                InvocationContext ctx = this.cache.getInvocationContext();
                Option optionOverride = ctx.getOptionOverrides();
                if (optionOverride != null && optionOverride.isCacheModeLocal() && ctx.getTransaction() == null) {
                    return super.invoke(m);
                }
                if (ctx.getTransaction() == null) break block18;
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    throw new CacheException("failed to get global transaction");
                }
                this.log.debug((Object)(" received method " + (Object)((Object)m)));
                switch (m.getMethodId()) {
                    case 18: {
                        retval = super.invoke(m);
                        if (!gtx.isRemote() && ctx.isOriginLocal() && (retval = this.broadcastPrepare(m, gtx)) instanceof Throwable) {
                            throw (Throwable)retval;
                        }
                        break block19;
                    }
                    case 11: {
                        Throwable temp = null;
                        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastCommit(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote commit", t);
                                temp = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp != null) {
                            throw temp;
                        }
                        break block19;
                    }
                    case 12: {
                        Throwable temp2 = null;
                        if (!gtx.isRemote() && ctx.isOriginLocal() && this.broadcastTxs.containsKey(gtx)) {
                            try {
                                this.broadcastRollback(gtx);
                            }
                            catch (Throwable t) {
                                this.log.error((Object)" a problem occurred with remote rollback", t);
                                temp2 = t;
                            }
                        }
                        retval = super.invoke(m);
                        if (temp2 != null) {
                            throw temp2;
                        }
                        break block19;
                    }
                    case 45: {
                        this.cache.getTransactionTable().get(gtx).setForceAsyncReplication(true);
                    }
                    default: {
                        this.log.debug((Object)(" received method " + (Object)((Object)m) + " not handling"));
                        retval = super.invoke(m);
                        break;
                    }
                }
                break block19;
            }
            throw new CacheException("transaction does not exist");
        }
        return retval;
    }

    protected Object broadcastPrepare(MethodCall methodCall, GlobalTransaction gtx) throws Throwable {
        int num_mods;
        boolean remoteCallSync = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_SYNC;
        Object[] args = methodCall.getArgs();
        List modifications = (List)args[1];
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            MethodCall toBroadcast = this.mapDataVersionedMethodCalls(methodCall, this.getTransactionWorkspace(gtx));
            this.broadcastTxs.put(gtx, gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(toBroadcast, remoteCallSync);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
        return null;
    }

    protected void broadcastCommit(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncCommitPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall commit_method = MethodCallFactory.create(MethodDeclarations.commitMethod, gtx);
                this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(commit_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.fatal((Object)"commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(GlobalTransaction gtx) throws Throwable {
        boolean remoteCallSync = this.configuration.isSyncRollbackPhase();
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall rollback_method = MethodCallFactory.create(MethodDeclarations.rollbackMethod, gtx);
                this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(rollback_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.error((Object)"rollback failed", (Throwable)e);
                throw e;
            }
        }
    }

    private MethodCall mapDataVersionedMethodCalls(MethodCall m, TransactionWorkspace w) {
        Object[] origArgs = m.getArgs();
        return MethodCallFactory.create(m.getMethod(), origArgs[0], this.translate((List)origArgs[1], w), origArgs[2], origArgs[3], origArgs[4]);
    }

    private List translate(List l, TransactionWorkspace w) {
        ArrayList<MethodCall> newList = new ArrayList<MethodCall>();
        for (MethodCall origCall : l) {
            if (MethodDeclarations.isDataGravitationMethod(origCall.getMethodId())) {
                newList.add(origCall);
                continue;
            }
            Object[] origArgs = origCall.getArgs();
            Fqn fqn = (Fqn)origArgs[1];
            DataVersion versionToBroadcast = this.getVersionToBroadcast(w, fqn);
            Object[] newArgs = new Object[origArgs.length + 1];
            for (int i = 0; i < origArgs.length; ++i) {
                newArgs[i] = origArgs[i];
            }
            newArgs[origArgs.length] = versionToBroadcast;
            MethodCall newCall = MethodCallFactory.create(MethodDeclarations.getVersionedMethod(origCall.getMethodId()), newArgs);
            newList.add(newCall);
        }
        return newList;
    }

    private DataVersion getVersionToBroadcast(TransactionWorkspace w, Fqn f) {
        WorkspaceNode n = w.getNode(f);
        if (n == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Fqn " + f + " not found in workspace; not using a data version."));
            }
            return null;
        }
        if (n.isVersioningImplicit()) {
            DefaultDataVersion v = (DefaultDataVersion)n.getVersion();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Fqn " + f + " has implicit versioning.  Broadcasting an incremented version."));
            }
            return v.increment();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Fqn " + f + " has explicit versioning.  Broadcasting the version as-is."));
        }
        return n.getVersion();
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.cache.getTransactionTable().get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("unable to map global transaction " + gtx + " to transaction entry");
        }
        return transactionEntry.getTransactionWorkSpace();
    }
}

