/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtil {
    public static final String MBEAN_CLASS_SUFFIX = "MBean";
    public static final String MBEAN_KEY = ",cache-interceptor=";
    public static final String JBOSS_CACHE_DOMAIN = "jboss.cache";
    public static final String PREFIX = "jboss.cache:service=Cache,clusterName=";
    private static final String JBOSS_SERVER_DOMAIN = "jboss";
    public static final String CACHE_TYPE_KEY = "cacheType=";
    public static final String PLAIN_CACHE_TYPE = "cacheType=Cache";

    public static void registerCacheMBean(MBeanServer server, CacheJmxWrapperMBean cache, String cacheObjectName) throws Exception {
        ObjectName on = new ObjectName(cacheObjectName);
        if (!server.isRegistered(on)) {
            server.registerMBean(cache, on);
        }
    }

    public static void registerInterceptors(MBeanServer server, List<Interceptor> interceptors, String cacheObjectName) throws Exception {
        if (server == null || interceptors == null || cacheObjectName == null) {
            return;
        }
        Interceptor interceptor = null;
        for (int i = 0; i < interceptors.size(); ++i) {
            interceptor = interceptors.get(i);
            boolean mbeanExists = true;
            try {
                Class.forName(interceptor.getClass().getName() + MBEAN_CLASS_SUFFIX);
            }
            catch (Throwable e) {
                mbeanExists = false;
            }
            String className = interceptor.getClass().getName();
            String serviceName = cacheObjectName + MBEAN_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (server.isRegistered(objName) || !mbeanExists) continue;
            server.registerMBean(interceptor, objName);
        }
    }

    public static String getCacheObjectName(CacheSPI cache) {
        return JmxUtil.getCacheObjectName(cache.getConfiguration(), cache.getClass().getName());
    }

    public static String getCacheObjectName(Configuration config, String cacheSPIClass) {
        String tmpName = config.getServiceName();
        if (tmpName == null) {
            tmpName = config.getClusterName() == null ? PREFIX + cacheSPIClass + System.currentTimeMillis() : PREFIX + config.getClusterName();
        }
        return tmpName;
    }

    public static void unregisterCacheMBean(MBeanServer server, String cacheObjectName) throws Exception {
        server.unregisterMBean(new ObjectName(cacheObjectName));
    }

    public static void unregisterInterceptors(MBeanServer server, List<Interceptor> interceptors, String cacheObjectName) throws Exception {
        if (server == null || interceptors == null || cacheObjectName == null) {
            return;
        }
        Interceptor interceptor = null;
        for (int i = 0; i < interceptors.size(); ++i) {
            interceptor = interceptors.get(i);
            String className = interceptor.getClass().getName();
            String serviceName = cacheObjectName + MBEAN_KEY + className.substring(className.lastIndexOf(46) + 1);
            ObjectName objName = new ObjectName(serviceName);
            if (!server.isRegistered(objName)) continue;
            server.unregisterMBean(objName);
        }
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers == null || servers.size() == 0) {
            return null;
        }
        for (int i = 0; i < servers.size(); ++i) {
            MBeanServer server = servers.get(i);
            if (server == null || server.getDefaultDomain() == null || !server.getDefaultDomain().equalsIgnoreCase(JBOSS_SERVER_DOMAIN)) continue;
            return server;
        }
        return servers.get(0);
    }
}

