/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.marshall.ObjectSerializationFactory;
import org.jboss.cache.transaction.GlobalTransaction;

public abstract class AbstractMarshaller
implements Marshaller {
    protected boolean useRegionBasedMarshalling;
    protected RegionManager regionManager;
    protected boolean defaultInactive;
    private static Log log = LogFactory.getLog(AbstractMarshaller.class);
    private Map<GlobalTransaction, String> transactions = new ConcurrentHashMap<GlobalTransaction, String>(16);

    protected void init(RegionManager manager, boolean defaultInactive, boolean useRegionBasedMarshalling) {
        this.useRegionBasedMarshalling = useRegionBasedMarshalling;
        this.defaultInactive = defaultInactive;
        this.regionManager = manager;
    }

    public byte[] objectToByteBuffer(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = ObjectSerializationFactory.createObjectOutputStream(baos);
        this.objectToObjectStream(obj, out);
        out.close();
        return baos.toByteArray();
    }

    public Object objectFromByteBuffer(byte[] bytes) throws Exception {
        ObjectInputStream in = ObjectSerializationFactory.createObjectInputStream(bytes);
        return this.objectFromObjectStream(in);
    }

    public Object objectFromStream(InputStream in) throws Exception {
        if (in instanceof ObjectInputStream) {
            return this.objectFromObjectStream((ObjectInputStream)in);
        }
        return this.objectFromObjectStream(ObjectSerializationFactory.createObjectInputStream(in));
    }

    protected String extractFqnFromMethodCall(MethodCall call) {
        MethodCall c0 = (MethodCall)((Object)call.getArgs()[0]);
        return this.extractFqn(c0);
    }

    protected String extractFqnFromListOfMethodCall(MethodCall call) {
        Object[] args = call.getArgs();
        MethodCall c0 = (MethodCall)((Object)((List)args[0]).get(0));
        return this.extractFqn(c0);
    }

    protected String extractFqn(MethodCall methodCall) {
        if (methodCall == null) {
            throw new NullPointerException("method call is null");
        }
        String fqnStr = null;
        Object[] args = methodCall.getArgs();
        switch (methodCall.getMethodId()) {
            case 10: 
            case 18: {
                List modifications = (List)args[1];
                fqnStr = this.extractFqn((MethodCall)((Object)modifications.get(0)));
                boolean one_phase_commit = (Boolean)args[args.length - 1];
                if (one_phase_commit) break;
                this.transactions.put((GlobalTransaction)args[0], fqnStr);
                break;
            }
            case 11: 
            case 12: {
                fqnStr = this.transactions.remove(args[0]);
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 35: {
                Fqn fqn = (Fqn)args[0];
                fqnStr = fqn.toString();
                break;
            }
            case 34: {
                Fqn fqn1 = (Fqn)args[1];
                fqnStr = fqn1.toString();
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 13: 
            case 22: {
                fqnStr = this.extractFqn((MethodCall)((Object)args[0]));
                break;
            }
            default: {
                if (MethodDeclarations.isCrudMethod(methodCall.getMethodId())) {
                    Fqn fqn2 = (Fqn)args[1];
                    fqnStr = fqn2.toString();
                    break;
                }
                throw new IllegalArgumentException("AbstractMarshaller.extractFqn(): Unknown id in method call: " + (Object)((Object)methodCall));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("extract(): received " + (Object)((Object)methodCall) + "extracted fqn: " + fqnStr));
        }
        return fqnStr;
    }

    protected Region getRegion(String fqnString) {
        Fqn<String> fqn = Fqn.fromString(fqnString);
        if (BuddyManager.isBackupFqn(fqn)) {
            fqn = fqn.getSubFqn(2, fqn.size());
        }
        return this.regionManager.getRegion(fqn, false);
    }
}

