/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.marshall.JavaObjectStreamFactory;
import org.jboss.cache.marshall.ObjectStreamFactory;

public class ObjectSerializationFactory {
    static boolean useJBossSerialization = false;
    private static Log log = LogFactory.getLog(ObjectSerializationFactory.class);
    static ObjectStreamFactory factory = new JavaObjectStreamFactory();

    public static ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return factory.createObjectOutputStream(out);
    }

    public static ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        return factory.createObjectInputStream(bytes);
    }

    public static ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return factory.createObjectInputStream(in);
    }

    public static boolean useJBossSerialization() {
        return useJBossSerialization;
    }

    static {
        String propString = System.getProperty("jboss.serialization");
        if (propString == null && (propString = System.getProperty("serialization.jboss")) != null) {
            log.info((Object)"The system property 'serialization.jboss' is deprecated and may be removed from future releases.  Please use 'jboss.serialization' instead.");
        }
        useJBossSerialization = true;
        if (propString != null) {
            useJBossSerialization = Boolean.valueOf(propString);
        }
        try {
            if (useJBossSerialization) {
                factory = (ObjectStreamFactory)Class.forName("org.jboss.cache.marshall.JBossObjectStreamFactory").newInstance();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to load JBossObjectStreamFactory.  Perhaps jboss-serialization jar not loaded?", (Throwable)e);
            log.error((Object)"Falling back to java serialization.");
        }
    }
}

