/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.FqnComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn<E>
implements Cloneable,
Externalizable,
Comparable<Fqn> {
    public static final String SEPARATOR = "/";
    private static final long serialVersionUID = -5351930616956603651L;
    private List<E> elements;
    private transient int hash_code = 0;
    public static final Fqn ROOT = new Fqn();
    private static Log log = LogFactory.getLog(Fqn.class);

    public Fqn() {
        this.elements = Collections.emptyList();
    }

    public Fqn(List<E> names) {
        this.elements = names != null ? Collections.unmodifiableList(new ArrayList<E>(names)) : Collections.emptyList();
    }

    public Fqn(E ... names) {
        this.elements = names != null ? Collections.unmodifiableList(Arrays.asList(names)) : Collections.emptyList();
    }

    public Fqn(Fqn<E> base, Fqn<E> relative) {
        this(base, relative.elements);
    }

    public Fqn(Fqn<E> base, List<E> relative) {
        ArrayList<E> elements = new ArrayList<E>(base.elements.size() + relative.size());
        elements.addAll(base.elements);
        elements.addAll(relative);
        this.elements = Collections.unmodifiableList(elements);
    }

    public Fqn(Fqn<E> base, E ... childNames) {
        ArrayList<E> elements = new ArrayList<E>(base.elements.size() + childNames.length);
        elements.addAll(base.elements);
        elements.addAll(Arrays.asList(childNames));
        this.elements = Collections.unmodifiableList(elements);
    }

    public static Fqn<String> fromString(String stringRepresentation) {
        if (stringRepresentation == null) {
            return ROOT;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(stringRepresentation, SEPARATOR);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return new Fqn<String>((List<String>)list);
    }

    public Fqn<E> getAncestor(int generation) {
        if (generation == 0) {
            return ROOT;
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn<E> getSubFqn(int startIndex, int endIndex) {
        return new Fqn<E>(this.elements.subList(startIndex, endIndex));
    }

    public int size() {
        return this.elements.size();
    }

    public E get(int n) {
        return this.elements.get(n);
    }

    public E getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    public boolean hasElement(E element) {
        return this.elements.lastIndexOf(element) != -1;
    }

    public Fqn<E> clone() throws CloneNotSupportedException {
        try {
            return (Fqn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Unable to clone Fqn " + this), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return ((Object)this.elements).equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this._hashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        StringBuffer sb = new StringBuffer();
        for (E element : this.elements) {
            sb.append(SEPARATOR).append(element);
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.elements.size());
        for (E element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readShort();
        this.elements = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            this.elements.add(in.readObject());
        }
    }

    public boolean isChildOf(Fqn<E> parentFqn) {
        return parentFqn.elements.size() != this.elements.size() && this.isChildOrEquals(parentFqn);
    }

    public boolean isChildOrEquals(Fqn<E> parentFqn) {
        List<E> parentList = parentFqn.elements;
        if (parentList.size() > this.elements.size()) {
            return false;
        }
        for (int i = parentList.size() - 1; i >= 0; --i) {
            if (parentList.get(i).equals(this.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    private int _hashCode() {
        int hashCode = 0;
        int count = 1;
        for (E element : this.elements) {
            E o = element;
            hashCode += o == null ? 0 : o.hashCode() * count++;
        }
        if (hashCode == 0) {
            hashCode = 65261;
        }
        return hashCode;
    }

    public Fqn<E> getParent() {
        switch (this.elements.size()) {
            case 0: 
            case 1: {
                return ROOT;
            }
        }
        return new Fqn<E>(this.elements.subList(0, this.elements.size() - 1));
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<E> peekElements() {
        return this.elements;
    }

    @Override
    public int compareTo(Fqn Fqn2) {
        return FqnComparator.INSTANCE.compare(this, Fqn2);
    }
}

