/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.JBossCacheGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheView {
    private JBossCacheGUI gui = null;
    boolean useConsole = false;
    private Cache<String, String> cache = null;
    private static Log log = LogFactory.getLog((String)JBossCacheView.class.getName());

    public JBossCacheView(Cache<String, String> cache) {
        this.setCache(cache);
    }

    public void setCache(Cache<String, String> cache) {
        this.cache = cache;
        if (this.gui != null) {
            this.gui.setCache(cache);
        }
    }

    public void start() throws Exception {
        if (this.gui == null) {
            log.info((Object)"start(): creating the GUI");
            System.out.println("start(): creating the GUI");
            this.gui = new JBossCacheGUI(this.cache, this.useConsole);
        }
    }

    public void stop() {
        if (this.gui != null) {
            log.info((Object)"stop(): disposing the GUI");
            this.gui.stopGui();
            this.gui = null;
        }
    }

    public static void main(String[] args) {
        String configurationFile = "META-INF/replSync-service.xml";
        boolean useConsole = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-console")) {
                useConsole = true;
                continue;
            }
            if (args[i].equals("-config")) {
                configurationFile = args[++i];
                continue;
            }
            JBossCacheView.help();
            return;
        }
        try {
            CacheFactory factory = DefaultCacheFactory.getInstance();
            Cache<String, String> cache = factory.createCache(configurationFile, false);
            cache.getConfiguration().setFetchInMemoryState(false);
            cache.start();
            JBossCacheView view = new JBossCacheView(cache);
            view.useConsole = useConsole;
            view.start();
        }
        catch (Exception ex) {
            log.error((Object)"Cannot start up!!", (Throwable)ex);
        }
    }

    private static void help() {
        System.out.println("JBossCacheView [-help] [-console] [-config <path to configuration file to use>] ");
        System.out.println();
        System.out.println("-console enables the embedded BeanShell console");
        System.out.println("-config allows you to provide a path to the configuration file to use.");
    }
}

