/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.FIFOConfiguration;
import org.jboss.cache.eviction.FIFOQueue;
import org.jboss.cache.eviction.NodeEntry;

public class FIFOAlgorithm
extends BaseEvictionAlgorithm {
    private static final Log log = LogFactory.getLog(FIFOAlgorithm.class);

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new FIFOQueue();
    }

    protected boolean shouldEvictNode(NodeEntry ne) {
        FIFOConfiguration config = (FIFOConfiguration)this.region.getEvictionPolicyConfig();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deciding whether node in queue " + ne.getFqn() + " requires eviction."));
        }
        int size = this.getEvictionQueue().getNumberOfNodes();
        return config.getMaxNodes() != 0 && size > config.getMaxNodes();
    }
}

