/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.SortedEvictionQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFUQueue
implements SortedEvictionQueue {
    private Map<Fqn, NodeEntry> nodeMap = new HashMap<Fqn, NodeEntry>();
    private LinkedList<NodeEntry> evictionList;
    private Comparator<NodeEntry> comparator = new LFUComparator();
    private Set<NodeEntry> removalQueue;
    private int numElements = 0;

    LFUQueue() {
        this.evictionList = new LinkedList();
        this.removalQueue = new HashSet<NodeEntry>();
    }

    @Override
    public NodeEntry getFirstNodeEntry() {
        try {
            NodeEntry ne;
            while ((ne = this.evictionList.getFirst()) != null && this.removalQueue.contains(ne)) {
                this.evictionList.removeFirst();
                this.removalQueue.remove(ne);
            }
            return ne;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public NodeEntry getNodeEntry(Fqn fqn) {
        return this.nodeMap.get(fqn);
    }

    @Override
    public NodeEntry getNodeEntry(String fqn) {
        return this.getNodeEntry(Fqn.fromString(fqn));
    }

    @Override
    public boolean containsNodeEntry(NodeEntry entry) {
        Fqn fqn = entry.getFqn();
        return this.getNodeEntry(fqn) != null;
    }

    @Override
    public void removeNodeEntry(NodeEntry entry) {
        NodeEntry ne = this.nodeMap.remove(entry.getFqn());
        if (ne != null) {
            this.removalQueue.add(ne);
            this.numElements -= ne.getNumberOfElements();
        }
    }

    @Override
    public void addNodeEntry(NodeEntry entry) {
        if (!this.containsNodeEntry(entry)) {
            Fqn fqn = entry.getFqn();
            entry.queue = this;
            this.nodeMap.put(fqn, entry);
            this.evictionList.add(entry);
            this.numElements += entry.getNumberOfElements();
        }
    }

    @Override
    public int getNumberOfNodes() {
        return this.nodeMap.size();
    }

    @Override
    public int getNumberOfElements() {
        return this.numElements;
    }

    @Override
    public void clear() {
        this.nodeMap.clear();
        this.evictionList.clear();
        this.removalQueue.clear();
        this.numElements = 0;
    }

    @Override
    public void resortEvictionQueue() {
        Collections.sort(this.evictionList, this.comparator);
    }

    @Override
    public void modifyElementCount(int difference) {
        this.numElements += difference;
    }

    void prune() {
        Iterator<NodeEntry> it = this.iterate();
        while (it.hasNext() && this.removalQueue.size() > 0) {
            if (!this.removalQueue.remove(it.next())) continue;
            it.remove();
        }
    }

    final List<NodeEntry> getEvictionList() {
        return this.evictionList;
    }

    final Set<NodeEntry> getRemovalQueue() {
        return this.removalQueue;
    }

    @Override
    public Iterator<NodeEntry> iterate() {
        return this.evictionList.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LFUComparator
    implements Comparator<NodeEntry> {
        LFUComparator() {
        }

        @Override
        public int compare(NodeEntry ne1, NodeEntry ne2) {
            int ne2NodeHits;
            if (ne1.equals(ne2)) {
                return 0;
            }
            int neNodeHits = ne1.getNumberOfNodeVisits();
            if (neNodeHits > (ne2NodeHits = ne2.getNumberOfNodeVisits())) {
                return 1;
            }
            if (neNodeHits < ne2NodeHits) {
                return -1;
            }
            if (neNodeHits == ne2NodeHits) {
                return 0;
            }
            throw new RuntimeException("Should never reach this condition");
        }
    }
}

