/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionQueue;

public class NodeEntry {
    private long modifiedTimeStamp;
    private long creationTimeStamp = System.currentTimeMillis();
    private int numberOfNodeVisits;
    private int numberOfElements;
    private Fqn fqn;
    private long inUseTimeoutTimestamp;
    private boolean currentlyInUse = false;
    EvictionQueue queue;

    private NodeEntry() {
    }

    public NodeEntry(Fqn fqn) {
        this();
        this.setFqn(fqn);
    }

    public NodeEntry(String fqn) {
        this();
        this.setFqn(Fqn.fromString(fqn));
    }

    public boolean isCurrentlyInUse() {
        return this.currentlyInUse;
    }

    public void setCurrentlyInUse(boolean currentlyInUse, long inUseTimeout) {
        this.currentlyInUse = currentlyInUse;
        if (inUseTimeout > 0L) {
            this.inUseTimeoutTimestamp = System.currentTimeMillis() + inUseTimeout;
        }
    }

    public long getInUseTimeoutTimestamp() {
        return this.inUseTimeoutTimestamp;
    }

    public long getModifiedTimeStamp() {
        return this.modifiedTimeStamp;
    }

    public void setModifiedTimeStamp(long modifiedTimeStamp) {
        this.modifiedTimeStamp = modifiedTimeStamp;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public void setCreationTimeStamp(long creationTimeStamp) {
        this.creationTimeStamp = creationTimeStamp;
    }

    public int getNumberOfNodeVisits() {
        return this.numberOfNodeVisits;
    }

    public void setNumberOfNodeVisits(int numberOfNodeVisits) {
        this.numberOfNodeVisits = numberOfNodeVisits;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        if (this.queue != null) {
            int difference = numberOfElements - this.numberOfElements;
            this.queue.modifyElementCount(difference);
        }
        this.numberOfElements = numberOfElements;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    void setFqn(Fqn fqn) {
        this.fqn = fqn;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof NodeEntry)) {
            return false;
        }
        NodeEntry ne = (NodeEntry)o;
        return this.fqn.equals(ne.getFqn());
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Fqn: ");
        if (this.fqn != null) {
            output.append(this.fqn);
        } else {
            output.append(" null");
        }
        output.append(" CreateTime: ").append(this.getCreationTimeStamp());
        output.append(" NodeVisits: ").append(this.getNumberOfNodeVisits());
        output.append(" ModifiedTime: ").append(this.getModifiedTimeStamp());
        output.append(" NumberOfElements: ").append(this.getNumberOfElements());
        output.append(" CurrentlyInUse: ").append(this.isCurrentlyInUse());
        return output.toString();
    }
}

