/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.cache.CacheListener;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.interceptors.CacheMgmtInterceptorMBean;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMgmtInterceptor
extends Interceptor
implements CacheMgmtInterceptorMBean,
NotificationBroadcaster {
    public static final String NOTIF_CACHE_STARTED = "org.jboss.cache.CacheStarted";
    public static final String NOTIF_CACHE_STOPPED = "org.jboss.cache.CacheStopped";
    public static final String NOTIF_NODE_CREATED = "org.jboss.cache.NodeCreated";
    public static final String NOTIF_NODE_MODIFIED = "org.jboss.cache.NodeModified";
    public static final String NOTIF_NODE_REMOVED = "org.jboss.cache.NodeRemoved";
    public static final String NOTIF_NODE_MOVED = "org.jboss.cache.NodeMoved";
    public static final String NOTIF_NODE_VISITED = "org.jboss.cache.NodeVisited";
    public static final String NOTIF_NODE_EVICTED = "org.jboss.cache.NodeEvicted";
    public static final String NOTIF_NODE_LOADED = "org.jboss.cache.NodeLoaded";
    public static final String NOTIF_NODE_ACTIVATED = "org.jboss.cache.NodeActivated";
    public static final String NOTIF_NODE_PASSIVATED = "org.jboss.cache.NodePassivated";
    public static final String NOTIF_VIEW_CHANGED = "org.jboss.cache.ViewChanged";
    private static final String MSG_CACHE_STARTED = "Cache has been started.";
    private static final String MSG_CACHE_STOPPED = "Cache has been stopped.";
    private static final String MSG_NODE_CREATED = "Node has been created.";
    private static final String MSG_NODE_MODIFIED = "Node has been modifed.";
    private static final String MSG_NODE_REMOVED = "Node has been removed.";
    private static final String MSG_NODE_MOVED = "Node has been moved.";
    private static final String MSG_NODE_VISITED = "Node has been visited.";
    private static final String MSG_NODE_EVICTED = "Node has been evicted.";
    private static final String MSG_NODE_LOADED = "Node has been loaded.";
    private static final String MSG_NODE_ACTIVATED = "Node has been activated.";
    private static final String MSG_NODE_PASSIVATED = "Node has been passivated.";
    private static final String MSG_VIEW_CHANGED = "Cache cluster view has changed.";
    private static final String NOTIFICATION_NAME = Notification.class.getName();
    private static final String NOTIFICATION_DESCR = "JBossCache event notifications";
    private AtomicLong m_seq = new AtomicLong(0L);
    private int m_listeners = 0;
    private long m_hit_times = 0L;
    private long m_miss_times = 0L;
    private long m_store_times = 0L;
    private long m_hits = 0L;
    private long m_misses = 0L;
    private long m_stores = 0L;
    private long m_evictions = 0L;
    private long m_start;
    private long m_reset = this.m_start = System.currentTimeMillis();
    private CacheMgmtListener m_listener = new CacheMgmtListener();
    private NotificationBroadcasterSupport m_broadcaster = null;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.m_broadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public Object invoke(MethodCall m) throws Throwable {
        Object retval;
        Object[] args = m.getArgs();
        if (!this.getStatisticsEnabled()) {
            return super.invoke(m);
        }
        switch (m.getMethodId()) {
            case 26: {
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                if (retval == null) {
                    this.m_miss_times += t2 - t1;
                    ++this.m_misses;
                    break;
                }
                this.m_hit_times += t2 - t1;
                ++this.m_hits;
                break;
            }
            case 3: 
            case 45: {
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                this.m_store_times += t2 - t1;
                ++this.m_stores;
                break;
            }
            case 1: 
            case 2: {
                Map attributes = (Map)args[2];
                long t1 = System.currentTimeMillis();
                retval = super.invoke(m);
                long t2 = System.currentTimeMillis();
                if (attributes == null || attributes.size() <= 0) break;
                this.m_store_times += t2 - t1;
                this.m_stores += (long)attributes.size();
                break;
            }
            case 8: 
            case 9: {
                retval = super.invoke(m);
                ++this.m_evictions;
                break;
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    @Override
    public long getHits() {
        return this.m_hits;
    }

    @Override
    public long getMisses() {
        return this.m_misses;
    }

    @Override
    public long getStores() {
        return this.m_stores;
    }

    @Override
    public long getEvictions() {
        return this.m_evictions;
    }

    @Override
    public double getHitMissRatio() {
        double total = this.m_hits + this.m_misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.m_hits / total;
    }

    @Override
    public double getReadWriteRatio() {
        if (this.m_stores == 0L) {
            return 0.0;
        }
        return (double)(this.m_hits + this.m_misses) / (double)this.m_stores;
    }

    @Override
    public long getAverageReadTime() {
        long total = this.m_hits + this.m_misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.m_hit_times + this.m_miss_times) / total;
    }

    @Override
    public long getAverageWriteTime() {
        if (this.m_stores == 0L) {
            return 0L;
        }
        return this.m_store_times / this.m_stores;
    }

    @Override
    public int getNumberOfAttributes() {
        return this.cache.getNumberOfAttributes();
    }

    @Override
    public int getNumberOfNodes() {
        return this.cache.getNumberOfNodes();
    }

    @Override
    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.m_start) / 1000L;
    }

    @Override
    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.m_reset) / 1000L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Hits", this.m_hits);
        retval.put("Misses", this.m_misses);
        retval.put("Stores", this.m_stores);
        retval.put("Evictions", this.m_evictions);
        retval.put("NumberOfAttributes", this.cache.getNumberOfAttributes());
        retval.put("NumberOfNodes", this.cache.getNumberOfNodes());
        retval.put("ElapsedTime", this.getElapsedTime());
        retval.put("TimeSinceReset", this.getTimeSinceReset());
        retval.put("AverageReadTime", this.getAverageReadTime());
        retval.put("AverageWriteTime", this.getAverageWriteTime());
        retval.put("HitMissRatio", this.getHitMissRatio());
        retval.put("ReadWriteRatio", this.getReadWriteRatio());
        return retval;
    }

    @Override
    public void resetStatistics() {
        this.m_hits = 0L;
        this.m_misses = 0L;
        this.m_stores = 0L;
        this.m_evictions = 0L;
        this.m_hit_times = 0L;
        this.m_miss_times = 0L;
        this.m_store_times = 0L;
        this.m_reset = System.currentTimeMillis();
    }

    private synchronized void emitNotifications(boolean emit) {
        if (emit) {
            ++this.m_listeners;
            this.cache.addCacheListener(this.m_listener);
        } else {
            --this.m_listeners;
            if (this.m_listeners <= 0) {
                this.cache.removeCacheListener(this.m_listener);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.m_broadcaster.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{NOTIF_CACHE_STARTED, NOTIF_CACHE_STOPPED, NOTIF_NODE_CREATED, NOTIF_NODE_EVICTED, NOTIF_NODE_LOADED, NOTIF_NODE_MODIFIED, NOTIF_NODE_ACTIVATED, NOTIF_NODE_PASSIVATED, NOTIF_NODE_REMOVED, NOTIF_NODE_VISITED, NOTIF_VIEW_CHANGED};
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, NOTIFICATION_NAME, NOTIFICATION_DESCR);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.m_broadcaster.addNotificationListener(listener, filter, handback);
        this.emitNotifications(true);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.m_broadcaster.removeNotificationListener(listener);
        this.emitNotifications(false);
    }

    private class CacheMgmtListener
    implements CacheListener {
        private CacheMgmtListener() {
        }

        private long seq() {
            return CacheMgmtInterceptor.this.m_seq.getAndIncrement();
        }

        public void cacheStarted(CacheSPI cache) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_CACHE_STARTED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_CACHE_STARTED);
            n.setUserData(cache.getConfiguration().getServiceName());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void cacheStopped(CacheSPI cache) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_CACHE_STOPPED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_CACHE_STOPPED);
            n.setUserData(cache.getConfiguration().getServiceName());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeCreated(Fqn fqn, boolean pre, boolean isLocal) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_CREATED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_CREATED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeEvicted(Fqn fqn, boolean pre, boolean isLocal) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_EVICTED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_EVICTED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeLoaded(Fqn fqn, boolean pre, Map data) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_LOADED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_LOADED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeModified(Fqn fqn, boolean pre, boolean isLocal, CacheListener.ModificationType modType, Map data) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_MODIFIED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_MODIFIED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeRemoved(Fqn fqn, boolean pre, boolean isLocal, Map data) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_REMOVED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_REMOVED);
            n.setUserData(new Object[]{fqn.toString(), pre, isLocal});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeMoved(Fqn from, Fqn to, boolean pre, boolean isLocal) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_MOVED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_MOVED);
            n.setUserData(new Object[]{from.toString(), to.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeVisited(Fqn fqn, boolean pre) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_VISITED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_VISITED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void viewChange(View view) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_VIEW_CHANGED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_VIEW_CHANGED);
            n.setUserData(view.toString());
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodeActivated(Fqn fqn, boolean pre) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_ACTIVATED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_ACTIVATED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }

        public void nodePassivated(Fqn fqn, boolean pre) {
            Notification n = new Notification(CacheMgmtInterceptor.NOTIF_NODE_PASSIVATED, (Object)this, this.seq(), CacheMgmtInterceptor.MSG_NODE_PASSIVATED);
            n.setUserData(new Object[]{fqn.toString(), pre});
            CacheMgmtInterceptor.this.m_broadcaster.sendNotification(n);
        }
    }
}

