/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getConfiguration().getLockAcquisitionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Object retval = null;
        switch (m.getMethodId()) {
            case 18: {
                GlobalTransaction gtx = this.getGlobalTransaction();
                try {
                    this.lockNodes(gtx);
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
                    try {
                        this.unlock(gtx);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)"Failed to unlock nodes, after failing to lock nodes during a prepare!  Locks are possibly in a very inconsistent state now!", t);
                    }
                    throw e;
                }
                retval = super.invoke(m);
                break;
            }
            case 11: 
            case 12: {
                try {
                    retval = super.invoke(m);
                }
                catch (Throwable throwable) {
                    try {
                        this.unlock(this.getGlobalTransaction());
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
                    }
                    throw throwable;
                }
                try {
                    this.unlock(this.getGlobalTransaction());
                }
                catch (Exception e) {
                    this.log.error((Object)"Failed to unlock nodes after a commit or rollback!  Locks are possibly in a very inconsistent state now!", (Throwable)e);
                }
                break;
            }
            case 33: {
                throw new CacheException("_lock() passed up the interceptor stack when Optimistic Locking is used.  This is NOT supported.");
            }
            default: {
                retval = super.invoke(m);
            }
        }
        return retval;
    }

    private void lockNodes(GlobalTransaction gtx) throws InterruptedException {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Locking nodes in transaction workspace for GlobalTransaction " + gtx));
        }
        for (WorkspaceNode workspaceNode : workspace.getNodes().values()) {
            NodeSPI node = workspaceNode.getNode();
            boolean acquired = node.getLock().acquire(gtx, this.lockAcquisitionTimeout, NodeLock.LockType.WRITE);
            if (acquired) {
                if (this.trace) {
                    this.log.trace((Object)("Acquired lock on node " + node.getFqn()));
                }
                this.cache.getTransactionTable().addLock(gtx, node.getLock());
                continue;
            }
            throw new CacheException("Unable to acquire lock on node " + node.getFqn());
        }
    }

    private void unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        entry.releaseAllLocksFIFO(gtx);
    }
}

