/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.FileCacheLoaderConfig;
import org.jboss.cache.marshall.ObjectSerializationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheLoader
extends AbstractCacheLoader {
    File root = null;
    String rootPath = null;
    Log log = LogFactory.getLog(this.getClass());
    private FileCacheLoaderConfig config;
    Map<Object, List<Modification>> transactions = new ConcurrentHashMap<Object, List<Modification>>();
    public static final String DATA = "data.dat";
    public static final String DIR_SUFFIX = "fdb";
    public static final Pattern PATH_PATTERN = Pattern.compile("[\\*<>|\"?]");
    public static final Pattern FQN_PATTERN = Pattern.compile("[\\\\\\/:*<>|\"?]");

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        String location;
        if (base instanceof FileCacheLoaderConfig) {
            this.config = (FileCacheLoaderConfig)base;
        } else if (base != null) {
            this.config = new FileCacheLoaderConfig(base);
        }
        String string = location = this.config != null ? this.config.getLocation() : null;
        if (location != null && location.length() > 0) {
            this.root = new File(location);
            this.rootPath = this.root.getAbsolutePath() + File.separator;
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public void create() throws Exception {
        if (this.root == null) {
            String tmpLocation = System.getProperty("java.io.tmpdir", "C:\\tmp");
            this.root = new File(tmpLocation);
            this.rootPath = this.root.getAbsolutePath() + File.separator;
        }
        if (!this.root.exists()) {
            boolean created;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Creating cache loader location " + this.root));
            }
            if (this.config.isCheckCharacterPortability()) {
                this.isCharacterPortableLocation(this.root.getAbsolutePath());
            }
            if (!(created = this.root.mkdirs())) {
                throw new IOException("Unable to create cache loader location " + this.root);
            }
        }
        if (!this.root.isDirectory()) {
            throw new IOException("Cache loader location [" + this.root + "] is not a directory!");
        }
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        File parent = this.getDirectory(fqn, false);
        if (parent == null) {
            return null;
        }
        File[] children = parent.listFiles();
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (!child.isDirectory() || !child.getName().endsWith(DIR_SUFFIX)) continue;
            String child_name = child.getName();
            child_name = child_name.substring(0, child_name.lastIndexOf(DIR_SUFFIX) - 1);
            s.add(child_name);
        }
        return s.size() == 0 ? null : s;
    }

    public Map get(Fqn fqn) throws Exception {
        return this.loadAttributes(fqn);
    }

    @Override
    public boolean exists(Fqn fqn) throws Exception {
        File f = this.getDirectory(fqn, false);
        return f != null;
    }

    @Override
    public Object put(Fqn fqn, Object key, Object value) throws Exception {
        HashMap<Object, Object> m = this.loadAttributes(fqn);
        if (m == null) {
            m = new HashMap<Object, Object>();
        }
        Object retval = m.put(key, value);
        this.storeAttributes(fqn, m);
        return retval;
    }

    public void put(Fqn fqn, Map attributes) throws Exception {
        this.put(fqn, attributes, false);
    }

    public void put(Fqn fqn, Map attributes, boolean erase) throws Exception {
        Map m;
        Map map = m = erase ? new HashMap() : this.loadAttributes(fqn);
        if (m == null) {
            m = new HashMap();
        }
        if (attributes != null) {
            m.putAll(attributes);
        }
        this.storeAttributes(fqn, m);
    }

    void put(Fqn fqn) throws Exception {
        this.getDirectory(fqn, true);
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        Map m = this.loadAttributes(fqn);
        if (m == null) {
            return null;
        }
        Object retval = m.remove(key);
        this.storeAttributes(fqn, m);
        return retval;
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        boolean flag;
        File dir = this.getDirectory(fqn, false);
        if (dir != null && !(flag = this.removeDirectory(dir, true))) {
            this.log.warn((Object)("failed removing " + fqn));
        }
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        boolean flag;
        File data;
        File f = this.getDirectory(fqn, false);
        if (f != null && (data = new File(f, DATA)).exists() && !(flag = data.delete())) {
            this.log.warn((Object)("failed removing file " + data.getName()));
        }
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        List<Modification> modifications = this.transactions.remove(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
    }

    @Override
    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    File getDirectory(Fqn fqn, boolean create) {
        File f = new File(this.getFullPath(fqn));
        if (!f.exists()) {
            if (create) {
                f.mkdirs();
            } else {
                return null;
            }
        }
        return f;
    }

    boolean removeDirectory(File dir, boolean include_start_dir) {
        boolean success = true;
        File[] subdirs = dir.listFiles();
        for (int i = 0; i < subdirs.length; ++i) {
            File file = subdirs[i];
            if (file.isFile() && file.getName().equals(DATA)) {
                if (file.delete()) continue;
                success = false;
                continue;
            }
            if (!file.isDirectory() || !file.getName().endsWith(DIR_SUFFIX)) continue;
            if (!this.removeDirectory(file, false)) {
                success = false;
            }
            if (file.delete()) continue;
            success = false;
        }
        if (include_start_dir && !dir.equals(this.root)) {
            if (dir.delete()) {
                return success;
            }
            success = false;
        }
        return success;
    }

    String getFullPath(Fqn fqn) {
        StringBuffer sb = new StringBuffer(this.rootPath);
        for (int i = 0; i < fqn.size(); ++i) {
            Object tmp = fqn.get(i);
            String tmp_dir = tmp.toString();
            sb.append(tmp_dir).append(".").append(DIR_SUFFIX).append(File.separator);
        }
        return sb.toString();
    }

    protected Map loadAttributes(Fqn fqn) throws Exception {
        File f = this.getDirectory(fqn, false);
        if (f == null) {
            return null;
        }
        File child = new File(f, DATA);
        if (!child.exists()) {
            return new HashMap(0);
        }
        Map m = (Map)this.unmarshall(child);
        return m;
    }

    protected void storeAttributes(Fqn fqn, Map attrs) throws Exception {
        File f = this.getDirectory(fqn, true);
        File child = new File(f, DATA);
        if (!child.exists()) {
            if (this.config.isCheckCharacterPortability()) {
                this.isLengthPortablePath(child.getAbsolutePath());
                this.isCharacterPortableTree(fqn);
            }
            if (!child.createNewFile()) {
                throw new IOException("Unable to create file: " + child);
            }
        }
        this.marshall(attrs, child);
    }

    protected boolean isCharacterPortableLocation(String fileAbsolutePath) {
        Matcher matcher = PATH_PATTERN.matcher(fileAbsolutePath);
        if (matcher.find()) {
            this.log.warn((Object)("Cache loader location ( " + fileAbsolutePath + " ) contains one of these characters: '*' '<' '>' '|' '\"' '?'"));
            this.log.warn((Object)"Directories containing these characters are illegal in some operative systems and could lead to portability issues");
            return false;
        }
        return true;
    }

    protected boolean isCharacterPortableTree(Fqn fqn) {
        List elements = fqn.peekElements();
        for (Object anElement : elements) {
            Matcher matcher = FQN_PATTERN.matcher(anElement.toString());
            if (!matcher.find()) continue;
            this.log.warn((Object)("One of the Fqn ( " + fqn + " ) elements contains one of these characters: '*' '<' '>' '|' '\"' '?' '\\' '/' ':' "));
            this.log.warn((Object)"Directories containing these characters are illegal in some operating systems and could lead to portability issues");
            return false;
        }
        return true;
    }

    protected boolean isLengthPortablePath(String absoluteFqnPath) {
        if (absoluteFqnPath.length() > 255) {
            this.log.warn((Object)("The full absolute path to the fqn that you are trying to store is bigger than 255 characters, this could lead to problems in Windows systems: " + absoluteFqnPath));
            return false;
        }
        return true;
    }

    protected Object unmarshall(File from) throws Exception {
        FileInputStream fileIn = new FileInputStream(from);
        ObjectInputStream input = ObjectSerializationFactory.createObjectInputStream(fileIn);
        Object unmarshalledObj = this.getMarshaller().objectFromObjectStream(input);
        input.close();
        return unmarshalledObj;
    }

    protected void marshall(Object obj, File to) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(to);
        ObjectOutputStream output = ObjectSerializationFactory.createObjectOutputStream(fileOut);
        this.getMarshaller().objectToObjectStream(obj, output);
        output.close();
    }
}

