/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AdjListJDBCCacheLoader;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoaderConfig;
import org.jboss.cache.marshall.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCacheLoader
extends AdjListJDBCCacheLoader {
    private static final Log log = LogFactory.getLog(JDBCCacheLoader.class);
    private JDBCCacheLoaderConfig config;

    @Override
    protected AdjListJDBCCacheLoaderConfig processConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof JDBCCacheLoaderConfig ? (JDBCCacheLoaderConfig)base : new JDBCCacheLoaderConfig(base);
        return this.config;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        HashMap<Object, Object> toAdd = new HashMap<Object, Object>();
        toAdd.put(key, value);
        Map existing = this._put(name, toAdd);
        return existing == null ? null : existing.get(key);
    }

    public void put(Fqn name, Map attributes) throws Exception {
        this._put(name, attributes);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.cf.getConnection();
            ps = conn.prepareStatement(this.config.getDeleteNodeSql());
            ps.setString(1, fqn.isRoot() ? fqn.toString() : fqn + "/");
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Failed to remove the node : " + fqn), (Throwable)e);
                throw new IllegalStateException("Failure while removing sub-tree (" + fqn + ")" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(conn);
                throw throwable;
            }
        }
        this.safeClose(ps);
        this.cf.close(conn);
    }

    @Override
    protected void getNodeDataList(Fqn fqn, List<NodeData> list) throws Exception {
        Map nodeAttributes = this.loadNode(fqn);
        if (nodeAttributes == null) {
            return;
        }
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            connection = this.cf.getConnection();
            ps = connection.prepareStatement(this.config.getRecursiveChildrenSql());
            ps.setString(1, fqn.isRoot() ? fqn.toString() : fqn.toString() + "/");
            rs = ps.executeQuery();
            while (rs.next()) {
                Map<Object, Object> attributes = this.readAttributes(rs, 2);
                Fqn<String> path = Fqn.fromString(rs.getString(1));
                NodeData nodeData = attributes == null || attributes.isEmpty() ? new NodeData(path) : new NodeData(path, attributes);
                list.add(nodeData);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Failed to load state for node(" + fqn + ") :" + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failed to load state for node(" + fqn + ") :" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(connection);
                throw throwable;
            }
        }
        this.safeClose(rs);
        this.safeClose(ps);
        this.cf.close(connection);
    }

    private Map<Object, Object> readAttributes(ResultSet rs, int index) throws SQLException {
        Map result;
        InputStream is = rs.getBinaryStream(index);
        if (is != null && !rs.wasNull()) {
            try {
                Object marshalledNode = this.unmarshall(is);
                result = (Map)marshalledNode;
            }
            catch (Exception e) {
                log.error((Object)"Failure while reading attribute set from db", (Throwable)e);
                throw new SQLException("Failure while reading attribute set from db " + e);
            }
        } else {
            result = null;
        }
        return result;
    }

    private Map _put(Fqn name, Map attributes) throws Exception {
        Map result = null;
        Map treeNode = this.loadNode(name);
        if (treeNode == null) {
            this.addNewSubtree(name, attributes);
        } else if (treeNode == NULL_NODE_IN_ROW) {
            this.updateNode(name, attributes);
        } else {
            HashMap newAttributes = new HashMap(treeNode);
            newAttributes.putAll(attributes);
            this.updateNode(name, newAttributes);
            result = treeNode;
        }
        return result;
    }

    private void addNewSubtree(Fqn name, Map attributes) throws Exception {
        Fqn currentNode = name;
        do {
            if (currentNode.equals(name)) {
                this.insertNode(currentNode, attributes);
                continue;
            }
            this.insertNode(currentNode, null);
        } while (!currentNode.isRoot() && !this.exists(currentNode = currentNode.getParent()));
    }

    @Override
    protected Log getLogger() {
        return log;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (!this.exists(Fqn.ROOT) && this.getNodeCount() > 0) {
            this.put(Fqn.ROOT, (Map)null);
        }
    }

    public int getNodeCount() throws Exception {
        int n;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.cf.getConnection();
            ps = conn.prepareStatement(this.config.getNodeCountSql());
            rs = ps.executeQuery();
            rs.next();
            n = rs.getInt(1);
        }
        catch (Exception e) {
            try {
                log.error((Object)("Failure while trying to get the count of persisted nodes: " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("Failure while trying to get the count of persisted nodes: " + e.getMessage());
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(conn);
                throw throwable;
            }
        }
        this.safeClose(rs);
        this.safeClose(ps);
        this.cf.close(conn);
        return n;
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }
}

