/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.DelegatingCacheLoader;

public class LocalDelegatingCacheLoader
extends DelegatingCacheLoader {
    CacheLoaderConfig.IndividualCacheLoaderConfig config;
    CacheImpl delegate = null;

    public LocalDelegatingCacheLoader() {
    }

    public LocalDelegatingCacheLoader(CacheImpl delegate) {
        this.delegate = delegate;
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        return this.delegate.getChildrenNames(fqn);
    }

    protected Map delegateGet(Fqn name) throws Exception {
        NodeSPI n = (NodeSPI)this.delegate.get(name);
        if (n == null) {
            return null;
        }
        Map m = n.getDataDirect();
        if (m == null) {
            m = new HashMap(0);
        }
        return m;
    }

    protected void setDelegateCache(CacheImpl delegate) {
        this.delegate = delegate;
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        return this.delegate.exists(name);
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.delegate.put(name, key, value);
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        this.delegate.put(name, attributes);
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.delegate.remove(name, key);
    }

    protected void delegateRemove(Fqn name) throws Exception {
        this.delegate.remove(name);
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        this.delegate.removeData(name);
    }

    protected void delegateLoadEntireState(ObjectOutputStream os) throws Exception {
        try {
            this.delegate.getStateTransferManager().getState(os, Fqn.ROOT, this.delegate.getConfiguration().getInitialStateRetrievalTimeout(), true, false);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Caught exception getting state from delegate", t);
        }
    }

    protected void delegateLoadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    protected void delegateStoreEntireState(ObjectInputStream is) throws Exception {
        this.delegate.getStateTransferManager().setState(is, Fqn.ROOT);
    }

    protected void delegateStoreState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }
}

