/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Naming;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.DelegatingCacheLoader;
import org.jboss.cache.loader.RmiDelegatingCacheLoaderConfig;
import org.jboss.cache.loader.rmi.RemoteTreeCache;

public class RmiDelegatingCacheLoader
extends DelegatingCacheLoader {
    private RmiDelegatingCacheLoaderConfig config = new RmiDelegatingCacheLoaderConfig();
    private CacheImpl cache;
    private RemoteTreeCache remoteCache;
    private boolean programmaticInit;

    public RmiDelegatingCacheLoader() {
    }

    public RmiDelegatingCacheLoader(CacheImpl cache, String host, int port, String bindName) {
        this.cache = cache;
        this.config.setHost(host);
        this.config.setPort(String.valueOf(port));
        this.config.setBindName(bindName);
        this.programmaticInit = true;
        this.tryToInitRemoteCache();
    }

    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = base instanceof RmiDelegatingCacheLoaderConfig ? (RmiDelegatingCacheLoaderConfig)base : new RmiDelegatingCacheLoaderConfig(base);
        this.tryToInitRemoteCache();
    }

    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.tryToInitRemoteCache();
    }

    protected Set delegateGetChildrenNames(Fqn fqn) throws Exception {
        return this.remoteCache != null ? this.remoteCache.getChildrenNames(fqn) : null;
    }

    protected Map delegateGet(Fqn name) throws Exception {
        NodeSPI n = (NodeSPI)(this.remoteCache != null ? this.remoteCache.get(name) : null);
        if (n == null) {
            return null;
        }
        return n.getDataDirect();
    }

    protected boolean delegateExists(Fqn name) throws Exception {
        return this.remoteCache != null && this.remoteCache.exists(name);
    }

    protected Object delegatePut(Fqn name, Object key, Object value) throws Exception {
        return this.remoteCache != null ? this.remoteCache.put(name, key, value) : null;
    }

    protected void delegatePut(Fqn name, Map attributes) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.put(name, attributes);
        }
    }

    protected Object delegateRemove(Fqn name, Object key) throws Exception {
        return this.remoteCache != null ? this.remoteCache.remove(name, key) : null;
    }

    protected void delegateRemove(Fqn name) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.remove(name);
        }
    }

    protected void delegateRemoveData(Fqn name) throws Exception {
        if (this.remoteCache != null) {
            this.remoteCache.removeData(name);
        }
    }

    protected void delegateLoadEntireState(ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    protected void delegateLoadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    protected void delegateStoreEntireState(ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    protected void delegateStoreState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    private void tryToInitRemoteCache() {
        if (this.config.getHost() == null || this.config.getPort() == null || this.cache == null) {
            return;
        }
        if (this.config.getBindName() == null) {
            this.config.setBindName(this.cache.getConfiguration().getClusterName());
        }
        if (!this.programmaticInit && this.cache.isCoordinator()) {
            this.remoteCache = null;
            return;
        }
        String name = "//" + this.config.getHost() + ":" + this.config.getPort() + "/" + this.config.getBindName();
        try {
            this.remoteCache = (RemoteTreeCache)Naming.lookup(name);
        }
        catch (Throwable t) {
            this.log.error((Object)("Unable to lookup remote cache at '" + name + "'."), t);
        }
    }
}

