/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.jmx.JmxUtil;
import org.jboss.cache.loader.tcp.TcpCacheServerMBean;

public class TcpCacheServer
implements TcpCacheServerMBean {
    ServerSocket srv_sock;
    InetAddress bind_addr = null;
    int port = 7500;
    CacheImpl cache;
    ObjectName cache_name;
    String config;
    boolean running = true;
    final List<Connection> conns = new LinkedList<Connection>();
    String agendId;
    Thread serverThread;
    boolean daemon = true;
    static Log log = LogFactory.getLog(TcpCacheServer.class);

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "n/a";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        if (bind_addr != null) {
            this.bind_addr = InetAddress.getByName(bind_addr);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getMBeanServerName() {
        return this.agendId;
    }

    public void setMBeanServerName(String name) {
        this.agendId = name;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public CacheImpl getCache() {
        return this.cache;
    }

    public void setCache(CacheImpl cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cache_name != null ? this.cache_name.toString() : "n/a";
    }

    public void setCacheName(String cache_name) throws MalformedObjectNameException {
        this.cache_name = new ObjectName(cache_name);
    }

    public void start() throws Exception {
        if (this.cache == null) {
            MBeanServer server = JmxUtil.getMBeanServer();
            if (this.cache_name != null && server != null) {
                this.cache = MBeanServerInvocationHandler.newProxyInstance(server, this.cache_name, CacheImpl.class, false);
            }
        }
        if (this.cache == null && this.config != null) {
            this.cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(this.config);
        }
        if (this.cache == null) {
            throw new CacheException("cache reference is not set");
        }
        this.srv_sock = new ServerSocket(this.port, 10, this.bind_addr);
        System.out.println("TcpCacheServer listening on : " + this.srv_sock.getInetAddress() + ":" + this.srv_sock.getLocalPort());
        log.info((Object)("TcpCacheServer listening on : " + this.srv_sock.getInetAddress() + ":" + this.srv_sock.getLocalPort()));
        this.running = true;
        this.serverThread = new Thread("TcpCacheServer"){

            public void run() {
                try {
                    while (TcpCacheServer.this.running) {
                        Socket client_sock = TcpCacheServer.this.srv_sock.accept();
                        Connection conn = new Connection(client_sock, TcpCacheServer.this.cache);
                        TcpCacheServer.this.conns.add(conn);
                        conn.start();
                    }
                }
                catch (SocketException se) {
                    if (!TcpCacheServer.this.running) {
                        log.info((Object)"Shutting down TcpCacheServer");
                    } else {
                        log.error((Object)"Caught exception! Shutting down server thread.", (Throwable)se);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Caught exception! Shutting down server thread.", (Throwable)e);
                }
            }
        };
        this.serverThread.setDaemon(this.daemon);
        this.serverThread.start();
    }

    public void stop() {
        this.running = false;
        for (Connection conn : this.conns) {
            conn.close();
        }
        this.conns.clear();
        if (this.srv_sock != null) {
            try {
                this.srv_sock.close();
                this.srv_sock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getConnections() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.conns.size()).append(" connections:\n");
        for (Connection c : this.conns) {
            sb.append(c).append("\n");
        }
        return sb.toString();
    }

    public void create() {
    }

    public void destroy() {
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        int port = 7500;
        String config = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-config")) {
                config = args[++i];
                continue;
            }
            TcpCacheServer.help();
            return;
        }
        TcpCacheServer server = new TcpCacheServer();
        server.daemon = false;
        server.setBindAddress(bind_addr);
        server.setPort(port);
        server.setConfig(config);
        server.create();
        server.start();
    }

    private static void help() {
        System.out.println("TcpCacheServer [-bind_addr <address>] [-port <port>] [-config <config file>] [-help]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Connection
    implements Runnable {
        Socket sock = null;
        ObjectInputStream input = null;
        ObjectOutputStream output = null;
        CacheImpl c;
        Thread t = null;

        public Connection(Socket sock, CacheImpl cache) throws IOException {
            this.sock = sock;
            this.output = new ObjectOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            this.output.flush();
            this.input = new ObjectInputStream(new BufferedInputStream(sock.getInputStream()));
            this.c = cache;
        }

        public void start() {
            this.t = new Thread((Runnable)this, "TcpCacheServer.Connection");
            this.t.setDaemon(true);
            this.t.start();
        }

        public void close() {
            this.t = null;
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TcpCacheServer.this.conns.remove(this);
        }

        @Override
        public void run() {
            while (this.t != null && Thread.currentThread().equals(this.t)) {
                int op;
                try {
                    op = this.input.readInt();
                }
                catch (IOException e) {
                    log.debug((Object)"Client closed socket");
                    this.close();
                    break;
                }
                try {
                    this.output.reset();
                    switch (op) {
                        case 1: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Set children = this.c.getChildrenNames(fqn);
                            this.output.writeObject(children);
                            break;
                        }
                        case 2: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.get(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 3: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            NodeSPI n = (NodeSPI)this.c.get(fqn);
                            if (n == null) {
                                this.output.writeObject(n);
                                break;
                            }
                            Map map = n.getDataDirect();
                            if (map == null) {
                                map = new HashMap();
                            }
                            this.output.writeObject(map);
                            break;
                        }
                        case 4: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            boolean flag = this.c.exists(fqn);
                            this.output.writeObject(flag);
                            break;
                        }
                        case 5: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object val = this.input.readObject();
                            Object retval = this.c.put(fqn, key, val);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 6: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Map map = (Map)this.input.readObject();
                            this.c.put(fqn, map);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 12: {
                            int length = this.input.readInt();
                            Object retval = Boolean.TRUE;
                            if (length > 0) {
                                ArrayList<Modification> mods = new ArrayList<Modification>(length);
                                for (int i = 0; i < length; ++i) {
                                    Modification mod = new Modification();
                                    mod.readExternal(this.input);
                                    mods.add(mod);
                                }
                                try {
                                    this.handleModifications(mods);
                                }
                                catch (Exception ex) {
                                    retval = ex;
                                }
                            }
                            this.output.writeObject(retval);
                            break;
                        }
                        case 7: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.remove(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 8: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.remove(fqn);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 9: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.removeData(fqn);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 10: {
                            ObjectOutputStream os = (ObjectOutputStream)this.input.readObject();
                            if (this.c.getCacheLoader() != null) {
                                this.c.getCacheLoader().loadEntireState(os);
                            }
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 11: {
                            ObjectInputStream is = (ObjectInputStream)this.input.readObject();
                            if (this.c.getCacheLoader() != null) {
                                this.c.getCacheLoader().storeEntireState(is);
                            }
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        default: {
                            log.error((Object)("Operation " + op + " unknown"));
                        }
                    }
                    this.output.flush();
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    try {
                        this.output.writeObject(e);
                        this.output.flush();
                    }
                    catch (IOException e1) {
                        log.error((Object)e1, (Throwable)e1);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sock != null) {
                sb.append(this.sock.getRemoteSocketAddress());
            }
            return sb.toString();
        }

        protected void handleModifications(List<Modification> modifications) throws CacheException {
            block9: for (Modification m : modifications) {
                switch (m.getType()) {
                    case PUT_DATA: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block9;
                    }
                    case PUT_DATA_ERASE: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block9;
                    }
                    case PUT_KEY_VALUE: {
                        this.c.put(m.getFqn(), m.getKey(), m.getValue());
                        continue block9;
                    }
                    case REMOVE_DATA: {
                        this.c.removeData(m.getFqn());
                        continue block9;
                    }
                    case REMOVE_KEY_VALUE: {
                        this.c.remove(m.getFqn(), m.getKey());
                        continue block9;
                    }
                    case REMOVE_NODE: {
                        this.c.remove(m.getFqn());
                        continue block9;
                    }
                    case MOVE: {
                        this.c.move(m.getFqn(), m.getFqn2());
                        continue block9;
                    }
                }
                log.error((Object)("modification type " + (Object)((Object)m.getType()) + " not known"));
            }
        }
    }
}

