/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Serializable;
import org.jboss.cache.marshall.InactiveRegionException;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.blocks.RpcDispatcher;

public class InactiveRegionAwareRpcDispatcher
extends RpcDispatcher {
    public InactiveRegionAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2, server_obj);
    }

    public InactiveRegionAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2, server_obj, deadlock_detection);
    }

    public InactiveRegionAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection, boolean concurrent_processing) {
        super(channel, l, l2, server_obj, deadlock_detection, concurrent_processing);
    }

    public InactiveRegionAwareRpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2, server_obj);
    }

    public Object handle(Message req) {
        Object body = null;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message or message buffer is null");
            }
            return null;
        }
        try {
            body = this.req_marshaller != null ? this.req_marshaller.objectFromByteBuffer(req.getBuffer()) : req.getObject();
        }
        catch (Throwable e) {
            if (e instanceof InactiveRegionException) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Exception from marshaller: " + e.getMessage()));
                }
                return null;
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"exception marshalling object", e);
            }
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message does not contain a MethodCall object");
            }
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[sender=" + req.getSrc() + "], method_call: " + method_call));
            }
            return method_call.invoke(this.server_obj);
        }
        catch (Throwable x) {
            return x;
        }
    }
}

