/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CacheStatus {
    INSTANTIATED,
    CREATING,
    CREATED,
    STARTING,
    STARTED,
    STOPPING,
    STOPPED,
    DESTROYING,
    DESTROYED,
    FAILED;

    private static final Log log;

    public boolean createAllowed() {
        switch (this) {
            case CREATING: 
            case CREATED: 
            case STARTING: 
            case STARTED: 
            case STOPPED: {
                log.debug((Object)("Ignoring call to create() as current state is " + (Object)((Object)this)));
            }
            case FAILED: {
                return false;
            }
            case STOPPING: 
            case DESTROYING: {
                log.warn((Object)("Ignoring call to create() while cache is " + (Object)((Object)this)));
                return false;
            }
        }
        return true;
    }

    public boolean needToDestroyFailedCache() {
        if (this == FAILED) {
            log.debug((Object)("need to call destroy() since current state is " + (Object)((Object)this)));
            return true;
        }
        return false;
    }

    public boolean startAllowed() {
        switch (this) {
            case STARTING: 
            case STARTED: 
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug((Object)("Ignoring call to start() as current state is " + (Object)((Object)this)));
            }
            case FAILED: {
                return false;
            }
            case STOPPING: 
            case DESTROYING: {
                log.warn((Object)("Ignoring call to start() as current state is " + (Object)((Object)this)));
                return false;
            }
        }
        return true;
    }

    public boolean needCreateBeforeStart() {
        switch (this) {
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug((Object)("start() called while current state is " + (Object)((Object)this) + " -- call create() first"));
                return true;
            }
        }
        return false;
    }

    public boolean stopAllowed() {
        switch (this) {
            case CREATED: 
            case STOPPED: 
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug((Object)("Ignoring call to stop() as current state is " + (Object)((Object)this)));
                return false;
            }
            case CREATING: 
            case STARTING: 
            case STOPPING: 
            case DESTROYING: {
                log.warn((Object)("Ignoring call to stop() as current state is " + (Object)((Object)this)));
                return false;
            }
        }
        return true;
    }

    public boolean destroyAllowed() {
        switch (this) {
            case INSTANTIATED: 
            case DESTROYED: {
                log.debug((Object)("Ignoring call to destroy() as current state is " + (Object)((Object)this)));
                return false;
            }
            case CREATING: 
            case STARTING: 
            case STOPPING: 
            case DESTROYING: {
                log.warn((Object)("Ignoring call to destroy() as current state iswhile cache is " + (Object)((Object)this)));
                return false;
            }
            case STARTED: {
                return false;
            }
        }
        return true;
    }

    public boolean needStopBeforeDestroy() {
        if (this == STARTED) {
            log.warn((Object)("destroy() called while current state is " + (Object)((Object)this) + " -- call stop() first"));
            return true;
        }
        return false;
    }

    static {
        log = LogFactory.getLog(CacheStatus.class);
    }
}

