/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.util.Util;

public class RegionImpl
implements Region {
    private static final Log log = LogFactory.getLog(RegionImpl.class);
    private RegionManager regionManager;
    private Fqn fqn;
    private boolean active;
    private ClassLoader classLoader;
    private BlockingQueue<EvictedEventNode> nodeEventQueue = null;
    private int capacityWarnThreshold = 0;
    private EvictionRegionConfig configuration = new EvictionRegionConfig();
    private EvictionPolicy policy;

    public RegionImpl(Fqn fqn, RegionManager regionManager) {
        this.fqn = fqn;
        this.regionManager = regionManager;
        this.active = !regionManager.isDefaultInactive();
    }

    public RegionImpl(EvictionPolicy policy, EvictionRegionConfig config, Fqn fqn, RegionManager regionManager) {
        this(fqn, regionManager);
        this.configuration = config;
        this.policy = policy;
        this.createQueue();
    }

    public void registerContextClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void unregisterContextClassLoader() {
        this.classLoader = null;
    }

    public void activate() {
        this.regionManager.activate(this.fqn);
        this.active = true;
    }

    public void activateIfEmpty() {
        this.regionManager.activateIfEmpty(this.fqn);
        this.active = true;
    }

    public void deactivate() {
        this.regionManager.deactivate(this.fqn);
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public void markNodeCurrentlyInUse(Fqn fqn, long timeout) {
        EvictedEventNode markUse = new EvictedEventNode(fqn, NodeEventType.MARK_IN_USE_EVENT);
        markUse.setInUseTimeout(timeout);
        this.putNodeEvent(markUse);
    }

    public void unmarkNodeCurrentlyInUse(Fqn fqn) {
        EvictedEventNode markNoUse = new EvictedEventNode(fqn, NodeEventType.UNMARK_USE_EVENT);
        this.putNodeEvent(markNoUse);
    }

    public String toString() {
        return "RegionImpl{fqn=" + this.fqn + "; active=" + this.active + "; eviction=" + (this.getEvictionPolicy() != null) + "; timerThreadRegistered=" + (this.getEvictionPolicy() != null && this.regionManager.getEvictionTimerTask().isRegionRegisteredForProcessing(this)) + '}';
    }

    public int compareTo(Region other) {
        return this.getFqn().compareTo(other.getFqn());
    }

    public void putNodeEvent(EvictedEventNode event) {
        try {
            if (this.nodeEventQueue == null) {
                this.createQueue();
            }
            if (this.nodeEventQueue.size() > this.capacityWarnThreshold) {
                log.warn((Object)("putNodeEvent(): eviction node event queue size is at 98% threshold value of capacity: " + this.configuration.getEventQueueSize() + " Region: " + this.fqn + " You will need to reduce the wakeUpIntervalSeconds parameter."));
            }
            this.nodeEventQueue.put(event);
        }
        catch (InterruptedException e) {
            log.debug((Object)"give up put", (Throwable)e);
        }
    }

    public EvictedEventNode takeLastEventNode() {
        try {
            return this.nodeEventQueue.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.debug((Object)"trace", (Throwable)e);
            return null;
        }
    }

    public int nodeEventQueueSize() {
        return this.nodeEventQueue.size();
    }

    public void resetEvictionQueues() {
        this.nodeEventQueue.clear();
    }

    private synchronized void createQueue() {
        if (this.nodeEventQueue == null) {
            if (this.configuration == null) {
                throw new IllegalArgumentException("null eviction configuration");
            }
            int size = this.configuration.getEventQueueSize();
            this.capacityWarnThreshold = 98 * size / 100 - 100;
            if (this.capacityWarnThreshold <= 0) {
                throw new RuntimeException("Capacity warn threshold used in eviction is smaller than 1.");
            }
            this.nodeEventQueue = new LinkedBlockingQueue<EvictedEventNode>(size);
        }
    }

    public EvictionRegionConfig getEvictionRegionConfig() {
        return this.configuration;
    }

    public EvictionPolicyConfig getEvictionPolicyConfig() {
        return this.configuration == null ? null : this.configuration.getEvictionPolicyConfig();
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.policy;
    }

    public void setEvictionPolicy(EvictionPolicyConfig evictionPolicyConfig) {
        this.configuration.setEvictionPolicyConfig(evictionPolicyConfig);
        this.policy = this.createPolicy(evictionPolicyConfig.getEvictionPolicyClass());
        this.regionManager.getEvictionTimerTask().addRegionToProcess(this);
        if (this.nodeEventQueue == null) {
            this.createQueue();
        }
    }

    private EvictionPolicy createPolicy(String className) {
        if (className == null) {
            throw new IllegalArgumentException("null className");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Instantiating " + className));
            }
            EvictionPolicy ep = (EvictionPolicy)Util.loadClass(className).newInstance();
            ep.setCache(this.regionManager.getCache());
            return ep;
        }
        catch (Exception e) {
            log.fatal((Object)("Unable to instantiate eviction policy class " + className), (Throwable)e);
            return null;
        }
    }
}

