/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.File;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCacheGui;
import org.jboss.cache.TreeCacheViewMBean;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;

public class TreeCacheView
implements TreeCacheViewMBean {
    CacheJmxWrapperMBean cache_service = null;
    TreeCacheGui gui = null;
    CacheSPI cache;
    Log log = LogFactory.getLog(TreeCacheView.class);

    public TreeCacheView() throws Exception {
    }

    public TreeCacheView(Cache cache) throws Exception {
        this.setCache(cache);
    }

    public TreeCacheView(CacheJmxWrapper mbean) throws Exception {
        this.setCacheService(mbean);
    }

    public void create() {
    }

    public void start() throws Exception {
        if (this.gui == null) {
            this.log.info((Object)"start(): creating the GUI");
            this.gui = new TreeCacheGui(this.cache);
        }
    }

    public void stop() {
        if (this.gui != null) {
            this.log.info((Object)"stop(): disposing the GUI");
            this.gui.dispose();
            this.gui = null;
        }
    }

    public void destroy() {
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = (CacheSPI)cache;
        System.out.println("Cache " + cache);
        this.gui = cache != null ? new TreeCacheGui(this.cache) : null;
    }

    public CacheJmxWrapperMBean getCacheService() {
        return this.cache_service;
    }

    public void setCacheService(CacheJmxWrapperMBean cache_service) {
        this.cache_service = cache_service;
        this.setCache(cache_service == null ? null : cache_service.getCache());
    }

    void populateTree(String dir) throws Exception {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        this.put(Fqn.fromString(dir), null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                this.populateTree(dir + "/" + children[i]);
            }
        }
    }

    void put(Fqn fqn, Map m) {
        try {
            this.cache.put(fqn, m);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheView.put(): " + t));
        }
    }

    public static void main(String[] args) {
        CacheImpl cache = null;
        String start_directory = null;
        String mbean_name = "jboss.cache:service=CacheImpl";
        String props = TreeCacheView.getDefaultProps();
        boolean use_queue = false;
        int queue_interval = 5000;
        int queue_max_elements = 100;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-mbean_name")) {
                mbean_name = args[++i];
                continue;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-start_directory")) {
                start_directory = args[++i];
                continue;
            }
            if (args[i].equals("-use_queue")) {
                use_queue = true;
                continue;
            }
            if (args[i].equals("-queue_interval")) {
                queue_interval = Integer.parseInt(args[++i]);
                use_queue = true;
                continue;
            }
            if (args[i].equals("-queue_max_elements")) {
                queue_max_elements = Integer.parseInt(args[++i]);
                use_queue = true;
                continue;
            }
            TreeCacheView.help();
            return;
        }
        try {
            Log log = LogFactory.getLog(CacheImpl.class);
            MBeanServer srv = MBeanServerFactory.createMBeanServer();
            cache = (CacheImpl)DefaultCacheFactory.getInstance().createCache(false);
            Configuration c = cache.getConfiguration();
            c.setClusterName("TreeCacheGroup");
            c.setClusterConfig(props);
            c.setStateRetrievalTimeout(10000L);
            c.setCacheMode("REPL_ASYNC");
            if (use_queue) {
                c.setUseReplQueue(true);
                c.setReplQueueInterval(queue_interval);
                c.setReplQueueMaxElements(queue_max_elements);
            }
            log.info((Object)("registering the cache as " + mbean_name));
            CacheJmxWrapper mbean = new CacheJmxWrapper(cache);
            srv.registerMBean(mbean, new ObjectName(mbean_name));
            mbean.start();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(cache));
            TreeCacheView demo = new TreeCacheView(mbean);
            demo.create();
            demo.start();
            if (start_directory != null && start_directory.length() > 0) {
                demo.populateTree(start_directory);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String getDefaultProps() {
        return "UDP(ip_mcast=true;ip_ttl=64;loopback=false;mcast_addr=228.1.2.3;mcast_port=45566;mcast_recv_buf_size=80000;mcast_send_buf_size=150000;ucast_recv_buf_size=80000;ucast_send_buf_size=150000):PING(down_thread=true;num_initial_members=3;timeout=2000;up_thread=true):MERGE2(max_interval=20000;min_interval=10000):FD(down_thread=true;shun=true;up_thread=true):VERIFY_SUSPECT(down_thread=true;timeout=1500;up_thread=true):pbcast.NAKACK(down_thread=true;gc_lag=50;retransmit_timeout=600,1200,2400,4800;up_thread=true):pbcast.STABLE(desired_avg_gossip=20000;down_thread=true;up_thread=true):UNICAST(down_thread=true;min_threshold=10;timeout=600,1200,2400;window_size=100):FRAG(down_thread=true;frag_size=8192;up_thread=true):pbcast.GMS(join_retry_timeout=2000;join_timeout=5000;print_local_addr=true;shun=true):pbcast.STATE_TRANSFER(down_thread=true;up_thread=true)";
    }

    static void help() {
        System.out.println("TreeCacheView [-help] [-mbean_name <name of CacheImpl MBean>] [-start_directory <dirname>] [-props <props>] [-use_queue <true/false>] [-queue_interval <ms>] [-queue_max_elements <num>]");
    }

    static class ShutdownThread
    extends Thread {
        CacheImpl cache = null;

        ShutdownThread(CacheImpl cache) {
            this.cache = cache;
        }

        public void run() {
            this.cache.stop();
        }
    }
}

