/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.util.MapCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheLoader
implements CacheLoader {
    protected CacheSPI cache;
    protected RegionManager regionManager;
    private static final Log log = LogFactory.getLog(AbstractCacheLoader.class);

    public void put(Fqn fqn, Map<Object, Object> attributes, boolean erase) throws Exception {
        if (erase) {
            this.removeData(fqn);
        }
        MapCopy<Object, Object> attrs = attributes == null ? null : new MapCopy<Object, Object>(attributes);
        this.put(fqn, attrs);
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.storeState(Fqn.ROOT, is);
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream in) throws Exception {
        Object o;
        NodeData nd;
        this.remove(subtree);
        boolean moveToBuddy = subtree.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && subtree.size() > 1;
        Fqn fqn = null;
        Object objectFromStream = this.cache.getMarshaller().objectFromObjectStream(in);
        if (objectFromStream instanceof NodeDataMarker) {
            return;
        }
        List nodeData = (List)objectFromStream;
        Iterator i$ = nodeData.iterator();
        while (i$.hasNext() && !(nd = (NodeData)(o = i$.next())).isMarker()) {
            if (nd.isExceptionMarker()) {
                NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)nd;
                throw new CacheException("State provider cacheloader at node " + ndem.getCacheNodeIdentity() + " threw exception during loadState (see Caused by)", ndem.getCause());
            }
            fqn = moveToBuddy ? BuddyManager.getBackupFqn(subtree, nd.getFqn()) : nd.getFqn();
            if (nd.getAttributes() != null) {
                this.put(fqn, nd.getAttributes(), true);
                continue;
            }
            this.put(fqn, null);
        }
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        this.loadState(Fqn.ROOT, os);
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        this.loadStateHelper(subtree, os);
    }

    @Override
    public void setCache(CacheSPI c) {
        this.cache = c;
    }

    @Override
    public void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    protected void loadStateHelper(Fqn fqn, ObjectOutputStream out) throws Exception {
        LinkedList<NodeData> list = new LinkedList<NodeData>();
        this.getNodeDataList(fqn, list);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Loading state of " + list.size() + " nodes into stream"));
        }
        this.cache.getMarshaller().objectToObjectStream(list, out, fqn);
    }

    protected void getNodeDataList(Fqn fqn, List<NodeData> list) throws Exception {
        Map<Object, Object> attrs = this.get(fqn);
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(fqn) : new NodeData(fqn, attrs);
        list.add(nd);
        Set<?> children_names = this.getChildrenNames(fqn);
        if (children_names == null) {
            return;
        }
        for (Object children_name : children_names) {
            String child_name = (String)children_name;
            Fqn<Object> tmp_fqn = new Fqn<Object>(fqn, new Object[]{child_name});
            this.getNodeDataList(tmp_fqn, list);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        block9: for (Modification m : modifications) {
            switch (m.getType()) {
                case PUT_DATA: {
                    this.put(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_DATA_ERASE: {
                    this.removeData(m.getFqn());
                    this.put(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_KEY_VALUE: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block9;
                }
                case REMOVE_DATA: {
                    this.removeData(m.getFqn());
                    continue block9;
                }
                case REMOVE_KEY_VALUE: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block9;
                }
                case REMOVE_NODE: {
                    this.remove(m.getFqn());
                    continue block9;
                }
                case MOVE: {
                    this._move(m.getFqn(), m.getFqn2());
                    continue block9;
                }
            }
            throw new CacheException("Unknown modificatiobn " + (Object)((Object)m.getType()));
        }
    }

    private void _move(Fqn fqn, Fqn parent) throws Exception {
        Map<Object, Object> data;
        Object name = fqn.getLastElement();
        Fqn<Object> newFqn = new Fqn<Object>(parent, name);
        Set<?> childrenNames = this.getChildrenNames(fqn);
        if (childrenNames != null) {
            for (Object c : childrenNames) {
                this._move(new Fqn<Object>(fqn, c), newFqn);
            }
        }
        if ((data = this.get(fqn)) != null) {
            this.remove(fqn);
            this.put(newFqn, data);
        }
    }

    protected Marshaller getMarshaller() {
        return this.cache.getMarshaller();
    }
}

