/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.jboss.cache.loader.tcp.TcpCacheServerMBean;

public class TcpCacheServer
implements TcpCacheServerMBean {
    private ServerSocket srv_sock;
    private InetAddress bind_addr = null;
    private int port = 7500;
    private CacheSPI cache;
    private CacheJmxWrapperMBean wrapper;
    private String config;
    private boolean running = true;
    private final List<Connection> conns = Collections.synchronizedList(new LinkedList());
    boolean daemon = true;
    static Log log = LogFactory.getLog(TcpCacheServer.class);

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "n/a";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        if (bind_addr != null) {
            this.bind_addr = InetAddress.getByName(bind_addr);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(CacheSPI cache) {
        this.cache = cache;
    }

    public void setCacheJmxWrapper(CacheJmxWrapperMBean wrapper) {
        this.wrapper = wrapper;
    }

    public void start() throws Exception {
        if (this.cache == null) {
            if (this.wrapper != null) {
                this.cache = (CacheSPI)this.wrapper.getCache();
                if (this.cache == null) {
                    throw new CacheException("cache cannot be obtained from CacheJmxWrapperMBean; be sure start() is invoked on wrapper before it is invoked on the TcpCacheServer");
                }
            } else if (this.config != null) {
                this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache(this.config);
            }
        }
        if (this.cache == null) {
            throw new CacheException("cache reference is not set");
        }
        this.srv_sock = new ServerSocket(this.port, 10, this.bind_addr);
        log.info((Object)("TcpCacheServer listening on : " + this.srv_sock.getInetAddress() + ":" + this.srv_sock.getLocalPort()));
        this.running = true;
        Thread serverThread = new Thread("TcpCacheServer"){

            public void run() {
                try {
                    while (TcpCacheServer.this.running) {
                        Socket client_sock = TcpCacheServer.this.srv_sock.accept();
                        Connection conn = new Connection(client_sock, TcpCacheServer.this.cache);
                        TcpCacheServer.this.conns.add(conn);
                        conn.start();
                    }
                }
                catch (SocketException se) {
                    if (!TcpCacheServer.this.running) {
                        log.info((Object)"Shutting down TcpCacheServer");
                    } else {
                        log.error((Object)"Caught exception! Shutting down server thread.", (Throwable)se);
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Caught exception! Shutting down server thread.", (Throwable)e);
                }
            }
        };
        serverThread.setDaemon(this.daemon);
        serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        List<Connection> list = this.conns;
        synchronized (list) {
            ArrayList<Connection> copy = new ArrayList<Connection>(this.conns);
            for (Connection conn : copy) {
                conn.close();
            }
            this.conns.clear();
        }
        if (this.srv_sock != null) {
            try {
                this.srv_sock.close();
                this.srv_sock = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnections() {
        List<Connection> list = this.conns;
        synchronized (list) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.conns.size()).append(" connections:\n");
            for (Connection c : this.conns) {
                sb.append(c).append("\n");
            }
            return sb.toString();
        }
    }

    public void create() {
    }

    public void destroy() {
    }

    public static void main(String[] args) throws Exception {
        String bind_addr = null;
        int port = 7500;
        String config = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-bind_addr")) {
                bind_addr = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-config")) {
                config = args[++i];
                continue;
            }
            TcpCacheServer.help();
            return;
        }
        TcpCacheServer server = new TcpCacheServer();
        server.daemon = false;
        server.setBindAddress(bind_addr);
        server.setPort(port);
        server.setConfig(config);
        server.create();
        server.start();
    }

    private static void help() {
        System.out.println("TcpCacheServer [-bind_addr <address>] [-port <port>] [-config <config file>] [-help]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Connection
    implements Runnable {
        private Socket sock = null;
        private ObjectInputStream input = null;
        private ObjectOutputStream output = null;
        private CacheSPI c;
        private Thread t = null;

        public Connection(Socket sock, CacheSPI cache) throws IOException {
            this.sock = sock;
            this.output = new ObjectOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            this.output.flush();
            this.input = new ObjectInputStream(new BufferedInputStream(sock.getInputStream()));
            this.c = cache;
        }

        public void start() {
            this.t = new Thread((Runnable)this, "TcpCacheServer.Connection");
            this.t.setDaemon(true);
            this.t.start();
        }

        public void close() {
            this.t = null;
            try {
                if (this.output != null) {
                    this.output.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.input != null) {
                    this.input.close();
                }
            }
            catch (Throwable th) {
                // empty catch block
            }
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TcpCacheServer.this.conns.remove(this);
        }

        @Override
        public void run() {
            while (this.t != null && Thread.currentThread().equals(this.t)) {
                int op;
                try {
                    op = this.input.readInt();
                }
                catch (IOException e) {
                    log.debug((Object)"Client closed socket");
                    this.close();
                    break;
                }
                try {
                    this.output.reset();
                    switch (op) {
                        case 1: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Node node = this.c.getRoot().getChild(fqn);
                            Set<Object> children = node == null ? Collections.emptySet() : node.getChildrenNames();
                            this.output.writeObject(children);
                            break;
                        }
                        case 2: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.get(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 3: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            NodeSPI n = (NodeSPI)this.c.getRoot().getChild(fqn);
                            if (n == null) {
                                this.output.writeObject(n);
                                break;
                            }
                            Map map = n.getDataDirect();
                            if (map == null) {
                                map = new HashMap();
                            }
                            this.output.writeObject(map);
                            break;
                        }
                        case 4: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            boolean flag = this.c.getRoot().hasChild(fqn);
                            this.output.writeObject(flag);
                            break;
                        }
                        case 5: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object val = this.input.readObject();
                            Object retval = this.c.put(fqn, key, val);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 6: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Map map = (Map)this.input.readObject();
                            this.c.put(fqn, map);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 12: {
                            int length = this.input.readInt();
                            Object retval = Boolean.TRUE;
                            if (length > 0) {
                                ArrayList<Modification> mods = new ArrayList<Modification>(length);
                                for (int i = 0; i < length; ++i) {
                                    Modification mod = new Modification();
                                    mod.readExternal(this.input);
                                    mods.add(mod);
                                }
                                try {
                                    this.handleModifications(mods);
                                }
                                catch (Exception ex) {
                                    retval = ex;
                                }
                            }
                            this.output.writeObject(retval);
                            break;
                        }
                        case 7: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Object key = this.input.readObject();
                            Object retval = this.c.remove(fqn, key);
                            this.output.writeObject(retval);
                            break;
                        }
                        case 8: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            this.c.removeNode(fqn);
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 9: {
                            Fqn fqn = (Fqn)this.input.readObject();
                            Node node = this.c.getRoot().getChild(fqn);
                            if (node != null) {
                                node.clearData();
                                this.output.writeObject(true);
                                break;
                            }
                            this.output.writeObject(false);
                            break;
                        }
                        case 10: {
                            ObjectOutputStream os = (ObjectOutputStream)this.input.readObject();
                            if (this.c.getCacheLoaderManager() != null) {
                                this.c.getCacheLoaderManager().getCacheLoader().loadEntireState(os);
                            }
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        case 11: {
                            ObjectInputStream is = (ObjectInputStream)this.input.readObject();
                            if (this.c.getCacheLoaderManager() != null) {
                                this.c.getCacheLoaderManager().getCacheLoader().storeEntireState(is);
                            }
                            this.output.writeObject(Boolean.TRUE);
                            break;
                        }
                        default: {
                            log.error((Object)("Operation " + op + " unknown"));
                        }
                    }
                    this.output.flush();
                }
                catch (Exception e) {
                    log.debug((Object)e, (Throwable)e);
                    try {
                        this.output.writeObject(e);
                        this.output.flush();
                    }
                    catch (IOException e1) {
                        log.error((Object)e1, (Throwable)e1);
                    }
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sock != null) {
                sb.append(this.sock.getRemoteSocketAddress());
            }
            return sb.toString();
        }

        protected void handleModifications(List<Modification> modifications) throws CacheException {
            block9: for (Modification m : modifications) {
                switch (m.getType()) {
                    case PUT_DATA: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block9;
                    }
                    case PUT_DATA_ERASE: {
                        this.c.put(m.getFqn(), m.getData());
                        continue block9;
                    }
                    case PUT_KEY_VALUE: {
                        this.c.put(m.getFqn(), m.getKey(), m.getValue());
                        continue block9;
                    }
                    case REMOVE_DATA: {
                        Node n = this.c.getRoot().getChild(m.getFqn());
                        if (n == null) continue block9;
                        n.clearData();
                        continue block9;
                    }
                    case REMOVE_KEY_VALUE: {
                        this.c.remove(m.getFqn(), m.getKey());
                        continue block9;
                    }
                    case REMOVE_NODE: {
                        this.c.removeNode(m.getFqn());
                        continue block9;
                    }
                    case MOVE: {
                        this.c.move(m.getFqn(), m.getFqn2());
                        continue block9;
                    }
                }
                log.error((Object)("modification type " + (Object)((Object)m.getType()) + " not known"));
            }
        }
    }
}

