/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.jboss.logging.Logger;
import org.jboss.util.collection.WeakValueHashMap;

public class MarshalledValueInputStream
extends ObjectInputStream {
    private static Logger log = Logger.getLogger((Class)MarshalledValueInputStream.class);
    private static WeakValueHashMap classCache;

    public static void useClassCache(boolean flag) {
        classCache = flag ? new WeakValueHashMap() : null;
    }

    public static void flushClassCache() {
        classCache.clear();
    }

    public MarshalledValueInputStream(InputStream is) throws IOException {
        super(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        String className = v.getName();
        Class<?> resolvedClass = null;
        if (classCache != null) {
            WeakValueHashMap weakValueHashMap = classCache;
            synchronized (weakValueHashMap) {
                resolvedClass = (Class<?>)classCache.get((Object)className);
            }
        }
        if (resolvedClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                resolvedClass = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                resolvedClass = super.resolveClass(v);
            }
            if (classCache != null) {
                WeakValueHashMap weakValueHashMap = classCache;
                synchronized (weakValueHashMap) {
                    classCache.put((Object)className, resolvedClass);
                }
            }
        }
        return resolvedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            StringBuffer tmp = new StringBuffer("[");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    tmp.append(',');
                }
                tmp.append(interfaces[i]);
            }
            tmp.append(']');
            log.trace((Object)("resolveProxyClass called, ifaces=" + tmp.toString()));
        }
        ClassLoader loader = null;
        Class[] ifaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            WeakValueHashMap weakValueHashMap;
            Class iface = null;
            String className = interfaces[i];
            if (classCache != null) {
                weakValueHashMap = classCache;
                synchronized (weakValueHashMap) {
                    iface = (Class)classCache.get((Object)className);
                }
            }
            if (iface == null) {
                if (loader == null) {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                iface = loader.loadClass(className);
                if (classCache != null) {
                    weakValueHashMap = classCache;
                    synchronized (weakValueHashMap) {
                        classCache.put((Object)className, (Object)iface);
                    }
                }
            }
            ifaceClasses[i] = iface;
        }
        return Proxy.getProxyClass(loader, ifaceClasses);
    }
}

