/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.sockets;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;

public class DefaultSocketFactory
implements RMIServerSocketFactory,
Serializable {
    private transient InetAddress bindAddress;
    private int backlog = 200;

    public DefaultSocketFactory() {
        this(null, 200);
    }

    public DefaultSocketFactory(InetAddress bindAddress) {
        this(bindAddress, 200);
    }

    public DefaultSocketFactory(int backlog) {
        this(null, backlog);
    }

    public DefaultSocketFactory(InetAddress bindAddress, int backlog) {
        this.bindAddress = bindAddress;
        this.backlog = backlog;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = InetAddress.getByName(host);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket activeSocket = new ServerSocket(port, this.backlog, this.bindAddress);
        return activeSocket;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultSocketFactory;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

