/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.util.Classes;
import org.jboss.util.HashCode;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.stream.Printable;

public final class StackTrace
implements Serializable,
Cloneable,
Printable {
    public static final int UNLIMITED = 0;
    private static final String EMPTY_PREFIX = "";
    protected final List stack;

    public StackTrace(Throwable detail, int level, int limit) {
        if (level < 0) {
            throw new IllegalArgumentException("level < 0");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit < 0");
        }
        try {
            Parser parser = Parser.getInstance();
            this.stack = parser.parse(detail, level, limit);
        }
        catch (InstantiationException e) {
            throw new NestedRuntimeException(e);
        }
        catch (IOException e) {
            throw new NestedRuntimeException(e);
        }
    }

    public StackTrace(Throwable detail, int level) {
        this(detail, level, 0);
    }

    public StackTrace(Throwable detail) {
        this(detail, 0, 0);
    }

    public StackTrace(int level, int limit) {
        this(new Throwable(), level + 1, limit);
    }

    public StackTrace(int level) {
        this(new Throwable(), level + 1, 0);
    }

    public StackTrace() {
        this(new Throwable(), 1, 0);
    }

    protected StackTrace(List stack) {
        this.stack = stack;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((StackTrace)obj).stack.equals(this.stack);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Entry getEntry(int level) {
        return (Entry)this.stack.get(level);
    }

    public Entry getCallerEntry() {
        return this.getEntry(0);
    }

    public Entry getRootEntry() {
        return this.getEntry(this.stack.size() - 1);
    }

    public StackTrace getSubTrace(int level) {
        return new StackTrace(this.stack.subList(level, this.stack.size()));
    }

    public StackTrace getSubTrace(int level, int limit) {
        limit = limit > 0 ? Math.min(level + limit, this.stack.size()) : this.stack.size();
        return new StackTrace(this.stack.subList(level, limit));
    }

    public StackTrace getCallerTrace() {
        return this.getSubTrace(1);
    }

    public void print(PrintWriter writer, String prefix) {
        Iterator iter = this.stack.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            entry.print(writer, prefix);
        }
    }

    public void print(PrintWriter writer) {
        this.print(writer, EMPTY_PREFIX);
    }

    public void print(PrintStream stream, String prefix) {
        Iterator iter = this.stack.iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            entry.print(stream, prefix);
        }
    }

    public void print(PrintStream stream) {
        this.print(stream, EMPTY_PREFIX);
    }

    public void print(String prefix) {
        this.print(System.err, prefix);
    }

    public void print() {
        this.print(System.err);
    }

    public Iterator iterator() {
        return this.stack.iterator();
    }

    public int size() {
        return this.stack.size();
    }

    public static final Entry currentEntry() {
        return new StackTrace().getCallerEntry();
    }

    public static final Entry callerEntry() {
        return new StackTrace(1).getCallerEntry();
    }

    public static final Entry rootEntry() {
        return new StackTrace().getRootEntry();
    }

    public static class Parser {
        private static Parser instance = null;

        protected void skipDescription(BufferedReader reader) throws IOException {
            reader.readLine();
        }

        protected void setLevel(BufferedReader reader, int level) throws IOException {
            int i = 0;
            while (i < level) {
                reader.readLine();
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected byte[] readBytes(Throwable detail) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            try {
                detail.printStackTrace(ps);
                Object var5_4 = null;
                ps.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ps.close();
                throw throwable;
            }
            return baos.toByteArray();
        }

        protected BufferedReader createReader(Throwable detail) throws IOException {
            byte[] bytes = this.readBytes(detail);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            InputStreamReader reader = new InputStreamReader(bais);
            return new BufferedReader(reader);
        }

        /*
         * WARNING - void declaration
         */
        public List parse(Throwable detail, int level, int limit) throws IOException {
            String raw;
            BufferedReader reader = this.createReader(detail);
            this.skipDescription(reader);
            this.setLevel(reader, level);
            ArrayList<Entry> list = new ArrayList<Entry>();
            int count = 0;
            while ((raw = reader.readLine()) != null) {
                void var6_7;
                Entry entry = this.createEntry((String)var6_7);
                list.add(entry);
                if (limit > 0 && ++count >= limit) break;
            }
            return list;
        }

        protected Entry createEntry(String raw) throws IOException {
            return new Entry(raw);
        }

        public static final synchronized Parser getInstance() throws InstantiationException {
            if (instance == null) {
                instance = new Parser();
            }
            return instance;
        }
    }

    public static final class Entry
    implements Cloneable,
    Serializable,
    Printable {
        public static final String UNKNOWN = "<unknown>";
        public static final String DEFAULT = "<default>";
        protected String className = "<unknown>";
        protected String methodName = "<unknown>";
        protected String sourceFileName = "<unknown>";
        protected String lineNumber = "<unknown>";

        public Entry(String className, String methodName, String sourceFileName, String lineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.sourceFileName = sourceFileName;
            this.lineNumber = lineNumber;
        }

        public Entry(String raw) {
            this.parse(raw);
        }

        protected void parse(String raw) {
            int j = raw.indexOf("at ") + 3;
            int i = raw.indexOf("(");
            if (j == -1 || i == -1) {
                return;
            }
            String temp = raw.substring(j, i);
            if ((i = temp.lastIndexOf(".")) == -1) {
                return;
            }
            this.className = temp.substring(0, i);
            this.methodName = temp.substring(i + 1);
            j = raw.indexOf("(") + 1;
            i = raw.indexOf(":");
            if (j == -1) {
                return;
            }
            if (i == -1) {
                i = raw.indexOf(")");
                if (i == -1) {
                    return;
                }
                this.sourceFileName = raw.substring(j, i);
            } else {
                this.sourceFileName = raw.substring(j, i);
                j = i + 1;
                i = raw.lastIndexOf(")");
                this.lineNumber = i != -1 ? raw.substring(j, i) : raw.substring(j);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getShortClassName() {
            return Classes.stripPackageName(this.className);
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getFullMethodName() {
            return this.className + "." + this.methodName;
        }

        public String getSourceFileName() {
            return this.sourceFileName;
        }

        public String getLineNumber() {
            return this.lineNumber;
        }

        public String toString(String prefix) {
            StringBuffer buff = new StringBuffer();
            if (prefix != null) {
                buff.append(prefix);
            }
            buff.append(this.className).append(".").append(this.methodName).append("(").append(this.sourceFileName);
            if (!this.lineNumber.equals(UNKNOWN)) {
                buff.append(":").append(this.lineNumber);
            }
            buff.append(")");
            return buff.toString();
        }

        public String toString() {
            return this.toString(StackTrace.EMPTY_PREFIX);
        }

        public int hashCode() {
            return HashCode.generate(new String[]{this.className, this.methodName, this.sourceFileName, this.lineNumber});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == this.getClass()) {
                Entry entry = (Entry)obj;
                return entry.className.equals(this.className) && entry.methodName.equals(this.methodName) && entry.sourceFileName.equals(this.sourceFileName) && entry.lineNumber.equals(this.lineNumber);
            }
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void print(PrintWriter writer, String prefix) {
            writer.println(this.toString(prefix));
        }

        public void print(PrintWriter writer) {
            writer.println(this.toString());
        }

        public void print(PrintStream stream, String prefix) {
            stream.println(this.toString(prefix));
        }

        public void print(PrintStream stream) {
            stream.println(this.toString());
        }

        public void print(String prefix) {
            this.print(System.err, prefix);
        }

        public void print() {
            this.print(System.err);
        }
    }
}

