/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();

    public Set entrySet() {
        this.processQueue();
        return this.hash.entrySet();
    }

    /*
     * WARNING - void declaration
     */
    private void processQueue() {
        WeakValueRef ref;
        while ((ref = (WeakValueRef)this.queue.poll()) != null) {
            void var1_1;
            if (var1_1 != (WeakValueRef)this.hash.get(var1_1.key)) continue;
            this.hash.remove(var1_1.key);
        }
    }

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        this.hash = new HashMap(initialCapacity);
    }

    public WeakValueHashMap() {
        this.hash = new HashMap();
    }

    public WeakValueHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hash.containsKey(key);
    }

    public Object get(Object key) {
        this.processQueue();
        WeakReference ref = (WeakReference)this.hash.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        WeakValueRef rtn = this.hash.put(key, WeakValueRef.create(key, value, this.queue));
        if (rtn != null) {
            rtn = ((WeakReference)rtn).get();
        }
        return rtn;
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.hash.remove(key);
    }

    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static class WeakValueRef
    extends WeakReference {
        public Object key;

        private WeakValueRef(Object key, Object val, ReferenceQueue q) {
            super(val, q);
            this.key = key;
        }

        private static WeakValueRef create(Object key, Object val, ReferenceQueue q) {
            if (val == null) {
                return null;
            }
            return new WeakValueRef(key, val, q);
        }
    }
}

