/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;
import org.jboss.net.protocol.URLLister;
import org.jboss.net.protocol.URLListerBase;

public class FileURLLister
extends URLListerBase {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.net.protocol.file.FileURLLister"));

    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter) throws IOException {
        return this.listMembers(baseUrl, filter, false);
    }

    public Collection listMembers(URL baseUrl, URLLister.URLFilter filter, boolean scanNonDottedSubDirs) throws IOException {
        String baseUrlString = baseUrl.toString();
        if (!baseUrlString.endsWith("/")) {
            throw new IOException(new JBossStringBuilder().append("Does not end with '/', not a directory url: ").append(baseUrlString).toString());
        }
        File dir = new File(baseUrl.getPath());
        if (!dir.isDirectory()) {
            throw new FileNotFoundException(new JBossStringBuilder().append("Not pointing to a directory, url: ").append(baseUrlString).toString());
        }
        ArrayList resultList = new ArrayList();
        this.listFiles(baseUrl, filter, scanNonDottedSubDirs, resultList);
        return resultList;
    }

    private void listFiles(final URL baseUrl, final URLLister.URLFilter filter, boolean scanNonDottedSubDirs, ArrayList resultList) throws IOException {
        final File baseDir = new File(baseUrl.getPath());
        String[] filenames = baseDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                try {
                    return filter.accept(baseUrl, name);
                }
                catch (Exception e) {
                    log.debug((Object)new JBossStringBuilder().append("Unexpected exception filtering entry '").append(name).append("' in directory '").append((Object)baseDir).append("'").toString(), (Throwable)e);
                    return true;
                }
            }
        });
        if (filenames == null) {
            throw new IOException(new JBossStringBuilder().append("Could not list directory '").append((Object)baseDir).append("', reason unknown").toString());
        }
        String baseUrlString = baseUrl.toString();
        for (int i = 0; i < filenames.length; ++i) {
            String filename = filenames[i];
            File file = new File(baseDir, filename);
            boolean isDir = file.isDirectory();
            URL subUrl = this.createURL(baseUrlString, filename, isDir);
            if (scanNonDottedSubDirs && isDir && filename.indexOf(46) == -1) {
                this.listFiles(subUrl, filter, scanNonDottedSubDirs, resultList);
                continue;
            }
            resultList.add(subUrl);
        }
    }

    private URL createURL(String baseUrlString, String filename, boolean isDirectory) {
        try {
            return new URL(new JBossStringBuilder().append(baseUrlString).append(filename).append(isDirectory ? "/" : "").toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException();
        }
    }
}

