/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import edu.emory.mathcs.backport.java.util.AbstractList;
import edu.emory.mathcs.backport.java.util.LinkedList;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.util.Objects;
import org.jboss.util.SoftObject;

public class CachedList
extends AbstractList {
    protected final ReferenceQueue queue = new ReferenceQueue();
    protected final List list;

    public CachedList(List list) {
        this.list = list;
    }

    public CachedList() {
        this((List)new LinkedList());
    }

    private Object getObject(int index) {
        Object obj = this.list.get(index);
        return Objects.deref(obj);
    }

    public Object get(int index) {
        this.maintain();
        return this.getObject(index);
    }

    public int size() {
        this.maintain();
        return this.list.size();
    }

    public Object set(int index, Object obj) {
        this.maintain();
        SoftObject soft = SoftObject.create(obj, this.queue);
        soft = this.list.set(index, soft);
        return Objects.deref(soft);
    }

    public void add(int index, Object obj) {
        this.maintain();
        SoftObject soft = SoftObject.create(obj, this.queue);
        this.list.add(index, soft);
    }

    public Object remove(int index) {
        this.maintain();
        Object obj = this.list.remove(index);
        return Objects.deref(obj);
    }

    private void maintain() {
        SoftObject obj;
        int count = 0;
        while ((obj = (SoftObject)this.queue.poll()) != null) {
            ++count;
            this.list.remove(obj);
        }
        if (count != 0) {
            System.err.println(new JBossStringBuilder().append("vm reclaimed ").append(count).append(" objects").toString());
        }
    }
}

