/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import edu.emory.mathcs.backport.java.util.LinkedList;
import java.util.Iterator;
import java.util.List;
import org.jboss.util.NullArgumentException;
import org.jboss.util.collection.AbstractQueue;
import org.jboss.util.collection.EmptyCollectionException;
import org.jboss.util.collection.ReverseListIterator;

public class ListQueue
extends AbstractQueue {
    protected final List list;

    public ListQueue(List list, int maxSize) {
        super(maxSize);
        if (list == null) {
            throw new NullArgumentException("list");
        }
        this.list = list;
    }

    public ListQueue(int maxSize) {
        super(maxSize);
        this.list = new LinkedList();
    }

    public ListQueue(List list) {
        this(list, -1);
    }

    public ListQueue() {
        this((List)new LinkedList(), -1);
    }

    protected boolean addLast(Object obj) {
        return this.list.add(obj);
    }

    protected Object removeFirst() {
        return this.list.remove(0);
    }

    public int size() {
        return this.list.size();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Object getFront() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.list.get(0);
    }

    public Object getBack() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.list.get(this.list.size() - 1);
    }

    public Iterator reverseIterator() {
        return new ReverseListIterator(this.list);
    }

    public String toString() {
        return this.list.toString();
    }
}

