/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.naming;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.util.naming.Util;

public class NonSerializableFactory
implements ObjectFactory {
    private static Map wrapperMap = Collections.synchronizedMap(new HashMap());

    public static synchronized void bind(String key, Object target) throws NameAlreadyBoundException {
        if (wrapperMap.containsKey(key)) {
            throw new NameAlreadyBoundException(new JBossStringBuilder().append(key).append(" already exists in the NonSerializableFactory map").toString());
        }
        wrapperMap.put(key, target);
    }

    public static void rebind(String key, Object target) {
        wrapperMap.put(key, target);
    }

    public static void unbind(String key) throws NameNotFoundException {
        if (wrapperMap.remove(key) == null) {
            throw new NameNotFoundException(new JBossStringBuilder().append(key).append(" was not found in the NonSerializableFactory map").toString());
        }
    }

    public static void unbind(Name name) throws NameNotFoundException {
        String key = name.toString();
        if (wrapperMap.remove(key) == null) {
            throw new NameNotFoundException(new JBossStringBuilder().append(key).append(" was not found in the NonSerializableFactory map").toString());
        }
    }

    public static Object lookup(String key) {
        Object value = wrapperMap.get(key);
        return value;
    }

    public static Object lookup(Name name) {
        String key = name.toString();
        Object value = wrapperMap.get(key);
        return value;
    }

    public static synchronized void rebind(Context ctx, String key, Object target) throws NamingException {
        NonSerializableFactory.rebind(key, target);
        String className = target.getClass().getName();
        String factory = Class.forName("org.jboss.util.naming.NonSerializableFactory").getName();
        StringRefAddr addr = new StringRefAddr("nns", key);
        Reference memoryRef = new Reference(className, addr, factory, null);
        ctx.rebind(key, (Object)memoryRef);
    }

    public static synchronized void rebind(Name name, Object target) throws NamingException {
        NonSerializableFactory.rebind(name, target, false);
    }

    public static synchronized void rebind(Name name, Object target, boolean createSubcontexts) throws NamingException {
        String key = name.toString();
        InitialContext ctx = new InitialContext();
        if (createSubcontexts && name.size() > 1) {
            int size = name.size() - 1;
            Util.createSubcontext((Context)ctx, name.getPrefix(size));
        }
        NonSerializableFactory.rebind(ctx, key, target);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("nns");
        String key = (String)addr.getContent();
        Object target = wrapperMap.get(key);
        return target;
    }
}

