/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class FileURLConnection
extends URLConnection {
    protected File file;

    public FileURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
        this.file = new File(url.getPath().replace('/', File.separatorChar).replace('|', ':'));
        this.doOutput = false;
    }

    public File getFile() {
        return this.file;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getPath());
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new FileOutputStream(this.file);
    }

    public String getHeaderField(String name) {
        if (name.equalsIgnoreCase("last-modified")) {
            return String.valueOf(this.getLastModified());
        }
        return super.getHeaderField(name);
    }

    public Permission getPermission() throws IOException {
        return new FilePermission(this.file.getPath(), "read,write");
    }

    public long getLastModified() {
        return this.file.lastModified();
    }
}

