/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;

public abstract class TimerTask
implements Executable,
Comparable {
    static final int NEW = 1;
    static final int SCHEDULED = 2;
    static final int EXECUTED = 3;
    static final int CANCELLED = 4;
    private final Object m_lock = new Object();
    private int m_state;
    private long m_period;
    private long m_nextExecutionTime;

    protected TimerTask() {
        this.setState(1);
        this.m_period = 0L;
        this.m_nextExecutionTime = 0L;
    }

    protected TimerTask(long period) {
        this();
        if (period < 0L) {
            throw new IllegalArgumentException("Period can't be negative");
        }
        this.m_period = period;
    }

    public boolean cancel() {
        Object object = this.getLock();
        synchronized (object) {
            boolean ret = this.getState() == 2;
            this.setState(4);
            boolean bl = ret;
            return bl;
        }
    }

    public abstract void execute() throws Exception;

    public int compareTo(Object other) {
        if (!(other instanceof TimerTask)) {
            throw new IllegalArgumentException("Can't compare a TimerTask with something else");
        }
        if (other == this) {
            return 0;
        }
        TimerTask one = this;
        TimerTask two = (TimerTask)other;
        boolean swapped = false;
        if (one.hashCode() > two.hashCode()) {
            one = two;
            two = this;
            swapped = true;
        }
        TimerTask timerTask = one;
        synchronized (timerTask) {
            TimerTask timerTask2 = two;
            synchronized (timerTask2) {
                int res = (int)(one.getNextExecutionTime() - two.getNextExecutionTime());
                if (swapped) {
                    int n = -res;
                    return n;
                }
                int n = res;
                return n;
            }
        }
    }

    Object getLock() {
        return this.m_lock;
    }

    void setState(int state) {
        Object object = this.getLock();
        synchronized (object) {
            this.m_state = state;
        }
    }

    int getState() {
        Object object = this.getLock();
        synchronized (object) {
            int n = this.m_state;
            return n;
        }
    }

    boolean isPeriodic() {
        Object object = this.getLock();
        synchronized (object) {
            boolean bl = this.m_period > 0L;
            return bl;
        }
    }

    long getNextExecutionTime() {
        Object object = this.getLock();
        synchronized (object) {
            long l = this.m_nextExecutionTime;
            return l;
        }
    }

    void setNextExecutionTime(long time) {
        Object object = this.getLock();
        synchronized (object) {
            this.m_nextExecutionTime = time;
        }
    }

    protected long getPeriod() {
        Object object = this.getLock();
        synchronized (object) {
            long l = this.m_period;
            return l;
        }
    }
}

