/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jboss.util.NullArgumentException;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyReader;

public class FilePropertyReader
implements PropertyReader {
    protected String[] filenames;

    public FilePropertyReader(String[] filenames) {
        if (filenames == null) {
            throw new NullArgumentException("filenames");
        }
        this.filenames = filenames;
    }

    public FilePropertyReader(String filename) {
        this(new String[]{filename});
    }

    protected InputStream getInputStream(String filename) throws IOException {
        File file = new File(filename);
        return new FileInputStream(file);
    }

    protected void loadProperties(Properties props, String filename) throws IOException {
        if (filename == null) {
            throw new NullArgumentException("filename");
        }
        if (filename.equals("")) {
            throw new IllegalArgumentException("filename");
        }
        BufferedInputStream in = new BufferedInputStream(this.getInputStream(filename));
        props.load(in);
    }

    public Map readProperties() throws PropertyException, IOException {
        Properties props = new Properties();
        int i = 0;
        while (i < this.filenames.length) {
            this.loadProperties(props, this.filenames[i]);
            ++i;
        }
        return props;
    }
}

