/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.util.NullArgumentException;
import org.jboss.util.property.BoundPropertyListener;
import org.jboss.util.property.PropertyMap;

public class PropertyGroup
extends PropertyMap {
    protected final String basename;

    public PropertyGroup(String basename, Properties container) {
        super(container);
        if (basename == null) {
            throw new NullArgumentException("basename");
        }
        this.basename = basename;
    }

    public final String getBaseName() {
        return this.basename;
    }

    private String makePropertyName(String suffix) {
        return this.basename + "." + suffix;
    }

    private String makePropertyName(Object suffix) {
        return this.makePropertyName(String.valueOf(suffix));
    }

    public String toString() {
        return super.toString() + "{ basename=" + this.basename + " }";
    }

    public boolean containsKey(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.containsKey(this.makePropertyName(name));
    }

    public Object put(Object name, Object value) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.put(this.makePropertyName(name), value);
    }

    public Object get(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.get(this.makePropertyName(name));
    }

    public Object remove(Object name) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        return super.remove(this.makePropertyName(name));
    }

    protected void addPropertyListener(BoundPropertyListener listener) {
        String name = this.makePropertyName(listener.getPropertyName());
        ArrayList<BoundPropertyListener> list = (ArrayList<BoundPropertyListener>)this.boundListeners.get(name);
        if (list == null) {
            list = new ArrayList<BoundPropertyListener>();
            this.boundListeners.put(name, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
            listener.propertyBound(this);
        }
    }

    protected boolean removePropertyListener(BoundPropertyListener listener) {
        String name = this.makePropertyName(listener.getPropertyName());
        List list = (List)this.boundListeners.get(name);
        boolean removed = false;
        if (list != null && (removed = list.remove(listener))) {
            listener.propertyUnbound(this);
        }
        return removed;
    }
}

