/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.property;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.property.DefaultPropertyReader;
import org.jboss.util.property.PropertyException;
import org.jboss.util.property.PropertyGroup;
import org.jboss.util.property.PropertyListener;
import org.jboss.util.property.PropertyMap;
import org.jboss.util.property.PropertyReader;

public final class PropertyManager {
    public static final String READER_PROPERTY_NAME = "org.jboss.util.property.reader";
    public static final String DEFAULT_PROPERTY_READER_TOKEN = "DEFAULT";
    private static final String[] DEFAULT_PROPERTY_READERS = new String[]{"DEFAULT"};
    private static PropertyMap props = new PropertyMap(System.getProperties());

    private PropertyManager() {
    }

    public static PropertyMap getDefaultPropertyMap() {
        return props;
    }

    public static void addPropertyListener(PropertyListener listener) {
        props.addPropertyListener(listener);
    }

    public static void addPropertyListeners(PropertyListener[] listeners) {
        props.addPropertyListeners(listeners);
    }

    public static boolean removePropertyListener(PropertyListener listener) {
        return props.removePropertyListener(listener);
    }

    public static void load(String prefix, Map map) throws PropertyException {
        props.load(prefix, map);
    }

    public static void load(Map map) throws PropertyException, IOException {
        props.load(map);
    }

    public static void load(PropertyReader reader) throws PropertyException, IOException {
        props.load(reader);
    }

    public static void load(String classname) throws PropertyException, IOException {
        props.load(classname);
    }

    public static String setProperty(String name, String value) {
        return (String)props.setProperty(name, value);
    }

    public static String removeProperty(String name) {
        return props.removeProperty(name);
    }

    public static String getProperty(String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static String getProperty(String name) {
        return props.getProperty(name);
    }

    public static String[] getArrayProperty(String base, String[] defaultValues) {
        return props.getArrayProperty(base, defaultValues);
    }

    public static String[] getArrayProperty(String name) {
        return props.getArrayProperty(name);
    }

    public static Iterator names() {
        return props.names();
    }

    public static boolean containsProperty(String name) {
        return props.containsProperty(name);
    }

    public static PropertyGroup getPropertyGroup(String basename) {
        return props.getPropertyGroup(basename);
    }

    public static PropertyGroup getPropertyGroup(String basename, int index) {
        return props.getPropertyGroup(basename, index);
    }

    static {
        System.setProperties(props);
        String[] readerNames = PropertyManager.getArrayProperty(READER_PROPERTY_NAME, DEFAULT_PROPERTY_READERS);
        int i = 0;
        while (i < readerNames.length) {
            try {
                if (readerNames[i].equals(DEFAULT_PROPERTY_READER_TOKEN)) {
                    PropertyManager.load(new DefaultPropertyReader());
                } else {
                    PropertyManager.load(readerNames[i]);
                }
            }
            catch (IOException e) {
                ThrowableHandler.add(e);
            }
            ++i;
        }
    }
}

