/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.sockets;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import org.jboss.net.sockets.MethodHash;
import org.jboss.net.sockets.RMIMultiSocketClient;
import org.jboss.net.sockets.RMIMultiSocketHandler;

public class RMIMultiSocketServer {
    private static HashMap handlermap = new HashMap();
    private static HashMap stubmap = new HashMap();

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, Class[] interfaces, int numSockets) throws RemoteException {
        Remote[] stubs = new Remote[numSockets];
        Method[] methods = obj.getClass().getMethods();
        HashMap<Long, Method> invokerMap = new HashMap<Long, Method>();
        int i = 0;
        while (i < methods.length) {
            Long methodkey = new Long(MethodHash.calculateHash(methods[i]));
            invokerMap.put(methodkey, methods[i]);
            ++i;
        }
        RMIMultiSocketHandler[] handlers = new RMIMultiSocketHandler[numSockets];
        int i2 = 0;
        while (i2 < numSockets) {
            int theport = port == 0 ? 0 : port + i2;
            handlers[i2] = new RMIMultiSocketHandler(obj, invokerMap);
            stubs[i2] = UnicastRemoteObject.exportObject(handlers[i2], theport, csf, ssf);
            ++i2;
        }
        Remote remote = (Remote)Proxy.newProxyInstance(obj.getClass().getClassLoader(), interfaces, (InvocationHandler)new RMIMultiSocketClient(stubs));
        stubmap.put(remote, stubs);
        handlermap.put(remote, handlers);
        return remote;
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, int numSockets) throws RemoteException {
        return RMIMultiSocketServer.exportObject(obj, port, csf, ssf, obj.getClass().getInterfaces(), numSockets);
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        handlermap.remove(obj);
        Remote[] stubs = (Remote[])stubmap.remove(obj);
        int i = 0;
        while (i < stubs.length) {
            UnicastRemoteObject.unexportObject(stubs[i], force);
            ++i;
        }
        return true;
    }
}

