/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.util.CloneableObject;
import org.jboss.util.NullArgumentException;
import org.jboss.util.PrettyString;
import org.jboss.util.state.State;
import org.jboss.util.state.StateMachine;

public class DefaultStateMachineModel
extends CloneableObject
implements StateMachine.Model,
Serializable,
PrettyString.Appendable {
    protected Map acceptingMap = new HashMap();
    protected Entry initial;
    protected Entry current;

    public StringBuffer appendPrettyString(StringBuffer buff, String prefix) {
        buff.append(prefix).append(super.toString()).append(" {").append("\n");
        buff.append(prefix).append("  Accepting state mappings:\n");
        Iterator iter = this.acceptingMap.keySet().iterator();
        while (iter.hasNext()) {
            buff.append(prefix).append("    ").append(this.acceptingMap.get((State)iter.next()));
            buff.append("\n");
        }
        buff.append(prefix).append("  Initial state: ").append(this.initial == null ? null : this.initial.state).append("\n");
        buff.append(prefix).append("  Current state: ").append(this.current == null ? null : this.current.state).append("\n");
        buff.append(prefix).append("}");
        return buff;
    }

    public String toString() {
        return this.appendPrettyString(new StringBuffer(), "").toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultStateMachineModel model = (DefaultStateMachineModel)obj;
            return (this.current == model.current || this.current != null && this.current.equals(model.current)) && (this.initial == model.initial || this.initial != null && this.initial.equals(model.initial)) && (this.acceptingMap == model.acceptingMap || this.acceptingMap != null && this.acceptingMap.equals(model.acceptingMap));
        }
        return false;
    }

    protected Entry getEntry(State state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        return (Entry)this.acceptingMap.get(state);
    }

    protected Entry putEntry(State state, Set acceptable) {
        return this.acceptingMap.put(state, new Entry(state, acceptable));
    }

    public boolean isMappedState(State state) {
        if (state == null) {
            return false;
        }
        return this.getEntry(state) != null;
    }

    public State getMappedState(State state) {
        Entry entry = this.getEntry(state);
        if (entry != null) {
            return entry.state;
        }
        throw new IllegalArgumentException("State not mapped: " + state);
    }

    public Set addState(State state, Set acceptable) {
        Entry prevEntry = this.getEntry(state);
        if (this.containsState(state)) {
            this.updateAcceptableMapping(state, false);
        }
        this.putEntry(state, acceptable);
        if (acceptable != null) {
            Iterator iter = acceptable.iterator();
            while (iter.hasNext()) {
                State temp = (State)iter.next();
                if (temp == null) {
                    throw new NullArgumentException("acceptable", "Set Element");
                }
                if (temp.equals(state)) {
                    throw new IllegalArgumentException("Acceptable states must not include the accepting state: " + temp);
                }
                if (this.containsState(temp)) continue;
                this.addState(temp);
            }
        }
        return prevEntry == null ? null : prevEntry.acceptableStates;
    }

    public Set addState(State state, State[] acceptable) {
        if (acceptable == null) {
            throw new NullArgumentException("acceptable");
        }
        if (acceptable.length == 0) {
            return this.addState(state, (Set)null);
        }
        HashSet<State> set = new HashSet<State>(acceptable.length);
        int i = 0;
        while (i < acceptable.length) {
            if (acceptable[i] == null) {
                throw new NullArgumentException("acceptable", i);
            }
            set.add(acceptable[i]);
            ++i;
        }
        return this.addState(state, set);
    }

    public Set addState(State state, State acceptable) {
        HashSet<State> set = new HashSet<State>(1);
        set.add(acceptable);
        return this.addState(state, set);
    }

    public Set addState(State state) {
        return this.addState(state, (Set)null);
    }

    public void setInitialState(State state) {
        Entry entry = this.getEntry(state);
        if (entry == null) {
            throw new IllegalArgumentException("State not mapped: " + state);
        }
        this.initial = entry;
    }

    public State getInitialState() {
        return this.initial != null ? this.initial.state : null;
    }

    public void setCurrentState(State state) {
        Entry entry = this.getEntry(state);
        if (entry == null) {
            throw new IllegalArgumentException("State not mapped: " + state);
        }
        this.current = entry;
    }

    public State getCurrentState() {
        return this.current != null ? this.current.state : null;
    }

    public boolean containsState(State state) {
        return this.acceptingMap.containsKey(state);
    }

    public Set removeState(State state) {
        if (state == null) {
            throw new NullArgumentException("state");
        }
        if (this.current != null && state.equals(this.current.state)) {
            throw new IllegalArgumentException("Can not remove current state: " + state);
        }
        Entry prevEntry = this.getEntry(state);
        this.updateAcceptableMapping(state, true);
        this.acceptingMap.remove(state);
        return prevEntry.acceptableStates;
    }

    protected void updateAcceptableMapping(State state, boolean remove) {
        Iterator iter = this.acceptingMap.entrySet().iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next().getValue();
            if (entry.acceptableStates == null || !entry.acceptableStates.contains(state)) continue;
            entry.acceptableStates.remove(state);
            if (remove) continue;
            entry.acceptableStates.add(state);
        }
    }

    public Set states() {
        return Collections.unmodifiableSet(this.acceptingMap.keySet());
    }

    public Set acceptableStates(State state) {
        Entry entry = this.getEntry(state);
        if (entry.acceptableStates != null) {
            return Collections.unmodifiableSet(entry.acceptableStates);
        }
        return null;
    }

    public void clear() {
        this.acceptingMap.clear();
        this.initial = null;
        this.current = null;
    }

    public Object clone() {
        DefaultStateMachineModel model = (DefaultStateMachineModel)super.clone();
        model.acceptingMap = new HashMap();
        Iterator iter = this.acceptingMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            model.acceptingMap.put(entry.getKey(), ((Entry)entry.getValue()).clone());
        }
        if (model.current != null) {
            model.current = (Entry)this.current.clone();
        }
        if (model.initial != null) {
            model.initial = (Entry)this.initial.clone();
        }
        return model;
    }

    protected static class Entry
    extends CloneableObject
    implements Serializable {
        public State state;
        public Set acceptableStates;

        public Entry(State state, Set acceptableStates) {
            this.state = state;
            this.acceptableStates = acceptableStates;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == this.getClass()) {
                Entry entry = (Entry)obj;
                return (this.state == entry.state || this.state != null && this.state.equals(entry.state)) && (this.acceptableStates == entry.acceptableStates || this.acceptableStates != null && this.acceptableStates.equals(entry.acceptableStates));
            }
            return false;
        }

        public String toString() {
            return this.state + (this.acceptableStates == null ? " is final" : " accepts: " + this.acceptableStates);
        }

        public Object clone() {
            Entry entry = (Entry)super.clone();
            if (entry.acceptableStates != null) {
                entry.acceptableStates = new HashSet(this.acceptableStates);
            }
            return entry;
        }
    }
}

