/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.logging.Logger;
import org.jboss.util.ThrowableHandler;

public final class Streams {
    private static final Logger log = Logger.getLogger(class$org$jboss$util$stream$Streams == null ? (class$org$jboss$util$stream$Streams = Streams.class$("org.jboss.util.stream.Streams")) : class$org$jboss$util$stream$Streams);
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    static /* synthetic */ Class class$org$jboss$util$stream$Streams;

    public static boolean close(InputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean close(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean close(Object stream) {
        boolean success = false;
        if (stream instanceof InputStream) {
            success = Streams.close((InputStream)stream);
        } else if (stream instanceof OutputStream) {
            success = Streams.close((OutputStream)stream);
        } else {
            throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
        }
        return success;
    }

    public static boolean close(InputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean close(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean close(Object[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean fclose(OutputStream stream) {
        return Streams.flush(stream) && Streams.close(stream);
    }

    public static boolean fclose(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.fclose(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean flush(OutputStream stream) {
        if (stream == null) {
            return true;
        }
        boolean success = true;
        try {
            stream.flush();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean flush(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.flush(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int read;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("copying " + input + " to " + output + " with buffer size: " + buffer.length);
        }
        while ((read = input.read(buffer)) != -1) {
            void var5_5;
            output.write(buffer, 0, (int)var5_5);
            total += (long)var5_5;
            if (!trace) continue;
            log.trace("bytes read: " + (int)var5_5 + "; total bytes read: " + total);
        }
        return total;
    }

    public static long copy(InputStream input, OutputStream output, int size) throws IOException {
        return Streams.copy(input, output, new byte[size]);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 2048);
    }

    public static long copyb(InputStream input, OutputStream output) throws IOException {
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        if (!(output instanceof BufferedOutputStream)) {
            output = new BufferedOutputStream(output);
        }
        long bytes = Streams.copy(input, output, 2048);
        output.flush();
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    public static long copySome(InputStream input, OutputStream output, byte[] buffer, long length) throws IOException {
        int read;
        long total = 0L;
        boolean trace = log.isTraceEnabled();
        int readLength = Math.min((int)length, buffer.length);
        if (trace) {
            log.trace("initial read length: " + readLength);
        }
        while (readLength != 0 && (read = input.read(buffer, 0, readLength)) != -1) {
            void var7_7;
            if (trace) {
                log.trace("read bytes: " + (int)var7_7);
            }
            output.write(buffer, 0, (int)var7_7);
            total += (long)var7_7;
            if (trace) {
                log.trace("total bytes read: " + total);
            }
            readLength = Math.min((int)(length - total), buffer.length);
            if (!trace) continue;
            log.trace("next read length: " + readLength);
        }
        return total;
    }

    public static long copySome(InputStream input, OutputStream output, int size, long length) throws IOException {
        return Streams.copySome(input, output, new byte[size], length);
    }

    public static long copySome(InputStream input, OutputStream output, long length) throws IOException {
        return Streams.copySome(input, output, 2048, length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

