/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.propertyeditor;

import [Ljava.lang.Class;;
import [Ljava.lang.String;;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.jboss.util.Classes;
import org.jboss.util.propertyeditor.ClassArrayEditor;
import org.jboss.util.propertyeditor.StringArrayEditor;

public class PropertyEditors {
    public static PropertyEditor findEditor(Class type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor findEditor(String typeName) throws ClassNotFoundException {
        Class<?> type = Classes.getPrimitiveTypeForName(typeName);
        if (type == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            type = loader.loadClass(typeName);
        }
        return PropertyEditorManager.findEditor(type);
    }

    public static PropertyEditor getEditor(Class type) {
        PropertyEditor editor = PropertyEditors.findEditor(type);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + type);
        }
        return editor;
    }

    public static PropertyEditor getEditor(String typeName) throws ClassNotFoundException {
        PropertyEditor editor = PropertyEditors.findEditor(typeName);
        if (editor == null) {
            throw new RuntimeException("No property editor for type: " + typeName);
        }
        return editor;
    }

    public static void registerEditor(Class type, Class editorType) {
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static void registerEditor(String typeName, String editorTypeName) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> type = loader.loadClass(typeName);
        Class<?> editorType = loader.loadClass(editorTypeName);
        PropertyEditorManager.registerEditor(type, editorType);
    }

    public static Object convertValue(String text, String typeName) throws ClassNotFoundException, IntrospectionException {
        PropertyEditor editor;
        Class<?> typeClass = Classes.getPrimitiveTypeForName(typeName);
        if (typeClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            typeClass = loader.loadClass(typeName);
        }
        if ((editor = PropertyEditorManager.findEditor(typeClass)) == null) {
            throw new IntrospectionException("No property editor for type=" + typeClass);
        }
        editor.setAsText(text);
        return editor.getValue();
    }

    public String[] getEditorSearchPath() {
        return PropertyEditorManager.getEditorSearchPath();
    }

    public void setEditorSearchPath(String[] path) {
        PropertyEditorManager.setEditorSearchPath(path);
    }

    static {
        String[] currentPath = PropertyEditorManager.getEditorSearchPath();
        int length = currentPath != null ? currentPath.length : 0;
        String[] newPath = new String[length + 2];
        System.arraycopy(currentPath, 0, newPath, 0, length);
        newPath[length] = "org.jboss.util.propertyeditor";
        newPath[length + 1] = "org.jboss.mx.util.propertyeditor";
        PropertyEditorManager.setEditorSearchPath(newPath);
        Class strArrayType = String;.class;
        PropertyEditorManager.registerEditor(strArrayType, StringArrayEditor.class);
        Class clsArrayType = Class;.class;
        PropertyEditorManager.registerEditor(clsArrayType, ClassArrayEditor.class);
    }
}

