/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collections;
import java.util.Map;
import org.jboss.util.collection.WeakValueHashMap;
import org.jboss.util.threadpool.BasicTaskWrapper;
import org.jboss.util.threadpool.BasicThreadPoolMBean;
import org.jboss.util.threadpool.MinPooledExecutor;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.Task;
import org.jboss.util.threadpool.TaskWrapper;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolFullException;
import org.jboss.util.threadpool.ThreadPoolStoppedException;

public class BasicThreadPool
implements ThreadPool,
BasicThreadPoolMBean {
    private static final ThreadGroup JBOSS_THREAD_GROUP = new ThreadGroup("JBoss Pooled Threads");
    private static final Map threadGroups = Collections.synchronizedMap(new WeakValueHashMap());
    private static final SynchronizedInt lastPoolNumber = new SynchronizedInt(0);
    private String name;
    private int poolNumber;
    private String blockingMode = "abort";
    private MinPooledExecutor executor;
    private BoundedLinkedQueue queue;
    private ThreadGroup threadGroup = JBOSS_THREAD_GROUP;
    private SynchronizedInt lastThreadNumber = new SynchronizedInt(0);
    private SynchronizedBoolean stopped = new SynchronizedBoolean(false);

    public BasicThreadPool() {
        this("ThreadPool");
    }

    public BasicThreadPool(String name) {
        ThreadPoolThreadFactory factory = new ThreadPoolThreadFactory();
        this.queue = new BoundedLinkedQueue(1024);
        this.executor = new MinPooledExecutor((Channel)this.queue, 100);
        this.executor.setMinimumPoolSize(100);
        this.executor.setKeepAliveTime(60000L);
        this.executor.setThreadFactory(factory);
        this.executor.abortWhenBlocked();
        this.poolNumber = lastPoolNumber.increment();
        this.setName(name);
    }

    public void stop(boolean immediate) {
        this.stopped.set(true);
        if (immediate) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        }
    }

    public void waitForTasks() throws InterruptedException {
        this.executor.awaitTerminationAfterShutdown();
    }

    public void waitForTasks(long maxWaitTime) throws InterruptedException {
        this.executor.awaitTerminationAfterShutdown(maxWaitTime);
    }

    public void runTaskWrapper(TaskWrapper wrapper) {
        if (this.stopped.get()) {
            wrapper.rejectTask(new ThreadPoolStoppedException("Thread pool has been stopped"));
            return;
        }
        wrapper.acceptTask();
        int waitType = wrapper.getTaskWaitType();
        switch (waitType) {
            case 2: {
                this.executeOnThread(wrapper);
                break;
            }
            default: {
                this.execute(wrapper);
            }
        }
        this.waitForTask(wrapper);
    }

    public void runTask(Task task) {
        BasicTaskWrapper wrapper = new BasicTaskWrapper(task);
        this.runTaskWrapper(wrapper);
    }

    public void run(Runnable runnable) {
        RunnableTaskWrapper wrapper = new RunnableTaskWrapper(runnable);
        this.runTaskWrapper(wrapper);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPoolNumber() {
        return this.poolNumber;
    }

    public String getThreadGroupName() {
        return this.threadGroup.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadGroupName(String threadGroupName) {
        ThreadGroup group;
        Map map = threadGroups;
        synchronized (map) {
            group = (ThreadGroup)threadGroups.get(threadGroupName);
            if (group == null) {
                group = new ThreadGroup(JBOSS_THREAD_GROUP, threadGroupName);
                threadGroups.put(threadGroupName, group);
            }
        }
        this.threadGroup = group;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getMaximumQueueSize() {
        return this.queue.capacity();
    }

    public void setMaximumQueueSize(int size) {
        this.queue.setCapacity(size);
    }

    public int getPoolSize() {
        return this.executor.getPoolSize();
    }

    public int getMinimumPoolSize() {
        return this.executor.getMinimumPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinimumPoolSize(int size) {
        MinPooledExecutor minPooledExecutor = this.executor;
        synchronized (minPooledExecutor) {
            this.executor.setKeepAliveSize(size);
            if (this.executor.getMaximumPoolSize() < size) {
                this.executor.setMinimumPoolSize(size);
                this.executor.setMaximumPoolSize(size);
            }
        }
    }

    public int getMaximumPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int size) {
        MinPooledExecutor minPooledExecutor = this.executor;
        synchronized (minPooledExecutor) {
            this.executor.setMinimumPoolSize(size);
            this.executor.setMaximumPoolSize(size);
            if (this.executor.getKeepAliveSize() > size) {
                this.executor.setKeepAliveSize(size);
            }
        }
    }

    public long getKeepAliveTime() {
        return this.executor.getKeepAliveTime();
    }

    public void setKeepAliveTime(long time) {
        this.executor.setKeepAliveTime(time);
    }

    public String getBlockingMode() {
        return this.blockingMode;
    }

    public void setBlockingMode(String mode) {
        this.blockingMode = mode;
        if (mode.equalsIgnoreCase("run")) {
            this.executor.runWhenBlocked();
        } else if (mode.equalsIgnoreCase("wait")) {
            this.executor.waitWhenBlocked();
        } else if (mode.equalsIgnoreCase("discard")) {
            this.executor.discardWhenBlocked();
        } else if (mode.equalsIgnoreCase("discardOldest")) {
            this.executor.discardOldestWhenBlocked();
        } else {
            this.blockingMode = "abort";
            this.executor.abortWhenBlocked();
        }
    }

    public ThreadPool getInstance() {
        return this;
    }

    public void stop() {
        this.stop(false);
    }

    public String toString() {
        return this.name + '(' + this.poolNumber + ')';
    }

    protected void executeOnThread(TaskWrapper wrapper) {
        wrapper.run();
    }

    protected void execute(TaskWrapper wrapper) {
        try {
            this.executor.execute(wrapper);
        }
        catch (Throwable t) {
            wrapper.rejectTask(new ThreadPoolFullException(t.toString()));
        }
    }

    protected void waitForTask(TaskWrapper wrapper) {
        wrapper.waitForTask();
    }

    private class ThreadPoolThreadFactory
    implements ThreadFactory {
        private ThreadPoolThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            String threadName = BasicThreadPool.this.toString() + "-" + BasicThreadPool.this.lastThreadNumber.increment();
            Thread thread = new Thread(BasicThreadPool.this.threadGroup, runnable, threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

