/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.jboss.xml.binding.AbstractMarshaller;
import org.jboss.xml.binding.AttributesImpl;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentWriter;
import org.jboss.xml.binding.DelegatingObjectModelProvider;
import org.jboss.xml.binding.GenericObjectModelProvider;
import org.jboss.xml.binding.ObjectModelProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DtdMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger(DtdMarshaller.class);
    private String publicId;
    private String systemId;
    private final AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private DTD dtd;
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final LinkedList elementStack = new LinkedList();

    public void mapPublicIdToSystemId(String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
    }

    public void marshal(Reader dtdReader, ObjectModelProvider provider, Object document, Writer writer) throws IOException, SAXException {
        int i;
        DTDParser parser = new DTDParser(dtdReader);
        this.dtd = parser.parse(true);
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        DTDElement[] roots = null;
        if (this.dtd.rootElement != null) {
            this.handleRootElement(document, this.dtd.rootElement);
        } else {
            roots = DtdMarshaller.getRootList(this.dtd);
            for (i = 0; i < roots.length; ++i) {
                this.handleRootElement(document, roots[i]);
            }
        }
        writer.write("<?xml version=\"");
        writer.write(this.version);
        writer.write("\" encoding=\"");
        writer.write(this.encoding);
        writer.write("\"?>\n");
        writer.write("<!DOCTYPE ");
        if (this.dtd.rootElement != null) {
            writer.write(this.dtd.rootElement.getName());
        } else {
            for (i = 0; i < roots.length; ++i) {
                writer.write(", ");
                writer.write(roots[i].getName());
            }
        }
        writer.write(" PUBLIC \"");
        writer.write(this.publicId);
        writer.write("\" \"");
        writer.write(this.systemId);
        writer.write("\">\n");
        ContentWriter contentWriter = new ContentWriter(writer);
        this.content.handleContent(contentWriter);
    }

    private void handleRootElement(Object o, DTDElement dtdRoot) {
        Element el = new Element(dtdRoot, true);
        this.elementStack.addLast(el);
        this.content.startDocument();
        Object root = this.provider.getRoot(o, this.systemId, dtdRoot.getName());
        this.stack.push(root);
        AttributesImpl attrs = this.provideAttributes(dtdRoot, root);
        this.content.startElement("", dtdRoot.getName(), dtdRoot.getName(), attrs);
        this.handleElement(this.dtd, dtdRoot, attrs);
        this.content.endElement("", dtdRoot.getName(), dtdRoot.getName());
        this.stack.pop();
        this.content.endDocument();
        this.elementStack.removeLast();
    }

    private final void handleElement(DTD dtd, DTDElement element, Attributes attrs) {
        DTDItem item = element.content;
        if (item instanceof DTDMixed) {
            this.handleMixedElement((DTDMixed)item, element.getName(), attrs);
        } else if (item instanceof DTDEmpty) {
            Object value = this.provider.getElementValue(this.stack.peek(), this.systemId, element.getName());
            if (Boolean.TRUE.equals(value)) {
                this.writeSkippedElements();
                this.content.startElement("", element.getName(), element.getName(), attrs);
                this.content.endElement("", element.getName(), element.getName());
            }
        } else if (item instanceof DTDContainer) {
            this.processContainer(dtd, (DTDContainer)item);
        } else {
            throw new IllegalStateException("Unexpected element: " + element.getName());
        }
    }

    private final void handleMixedElement(DTDMixed mixed, String elementName, Attributes attrs) {
        Object parent = this.stack.peek();
        DTDItem[] items = mixed.getItems();
        for (int i = 0; i < items.length; ++i) {
            Object value;
            DTDItem item = items[i];
            if (!(item instanceof DTDPCData) || (value = this.provider.getElementValue(parent, this.systemId, elementName)) == null) continue;
            this.writeSkippedElements();
            char[] ch = value.toString().toCharArray();
            this.content.startElement("", elementName, elementName, attrs);
            this.content.characters(ch, 0, ch.length);
            this.content.endElement("", elementName, elementName);
        }
    }

    private final void handleChildren(DTD dtd, DTDElement element, DTDCardinal elementCardinal) {
        Object parent = this.stack.peek();
        Object children = this.provider.getChildren(parent, this.systemId, element.getName());
        if (children != null) {
            boolean singleValued;
            Iterator<Object> iter = children instanceof Iterator ? (Iterator)children : (children instanceof Collection ? ((Collection)children).iterator() : Collections.singletonList(children).iterator());
            this.writeSkippedElements();
            Element el = new Element(element, true);
            this.elementStack.addLast(el);
            boolean bl = singleValued = elementCardinal == DTDCardinal.NONE || elementCardinal == DTDCardinal.OPTIONAL;
            if (singleValued) {
                this.content.startElement("", element.getName(), element.getName(), null);
            }
            while (iter.hasNext()) {
                AttributesImpl attrs;
                Object child = iter.next();
                this.stack.push(child);
                AttributesImpl attributesImpl = attrs = element.attributes.isEmpty() ? null : this.provideAttributes(element, child);
                if (!singleValued) {
                    this.content.startElement("", element.getName(), element.getName(), null);
                }
                this.handleElement(dtd, element, attrs);
                if (!singleValued) {
                    this.content.endElement(this.systemId, element.getName(), element.getName());
                }
                this.stack.pop();
            }
            if (singleValued) {
                this.content.endElement(this.systemId, element.getName(), element.getName());
            }
            this.elementStack.removeLast();
        } else {
            boolean removeLast = false;
            if (!(element.getContent() instanceof DTDMixed) && !(element.getContent() instanceof DTDEmpty)) {
                Element el = new Element(element);
                this.elementStack.addLast(el);
                removeLast = true;
            }
            AttributesImpl attrs = element.attributes.isEmpty() ? null : this.provideAttributes(element, parent);
            this.handleElement(dtd, element, attrs);
            if (removeLast) {
                Element el = (Element)this.elementStack.removeLast();
                if (el.started) {
                    DTDElement started = el.element;
                    this.content.endElement("", started.getName(), started.getName());
                }
            }
        }
    }

    private final void processContainer(DTD dtd, DTDContainer container) {
        DTDItem[] items = container.getItems();
        for (int i = 0; i < items.length; ++i) {
            DTDItem item = items[i];
            if (item instanceof DTDContainer) {
                this.processContainer(dtd, (DTDContainer)item);
                continue;
            }
            if (!(item instanceof DTDName)) continue;
            DTDName name = (DTDName)item;
            DTDElement element = (DTDElement)dtd.elements.get(name.value);
            this.handleChildren(dtd, element, name.getCardinal());
        }
    }

    private void writeSkippedElements() {
        Element el = (Element)this.elementStack.getLast();
        if (!el.started) {
            int firstNotStarted = this.elementStack.size() - 1;
            do {
                el = (Element)this.elementStack.get(--firstNotStarted);
            } while (!el.started);
            ++firstNotStarted;
            while (firstNotStarted < this.elementStack.size()) {
                el = (Element)this.elementStack.get(firstNotStarted++);
                DTDElement notStarted = el.element;
                if (log.isTraceEnabled()) {
                    log.trace("starting skipped> " + notStarted.getName());
                }
                this.content.startElement("", notStarted.getName(), notStarted.getName(), null);
                el.started = true;
            }
        }
    }

    private AttributesImpl provideAttributes(DTDElement element, Object container) {
        Hashtable attributes = element.attributes;
        AttributesImpl attrs = new AttributesImpl(attributes.size());
        Iterator attrIter = attributes.values().iterator();
        while (attrIter.hasNext()) {
            DTDAttribute attr = (DTDAttribute)attrIter.next();
            Object attrValue = this.provider.getAttributeValue(container, this.systemId, attr.getName());
            if (attrValue == null) continue;
            attrs.add(this.systemId, attr.getName(), attr.getName(), attr.getType().toString(), attrValue.toString());
        }
        return attrs;
    }

    protected static DTDElement[] getRootList(DTD dtd) {
        DTDElement element;
        Hashtable<String, DTDElement> roots = new Hashtable<String, DTDElement>();
        Enumeration e = dtd.elements.elements();
        while (e.hasMoreElements()) {
            element = (DTDElement)e.nextElement();
            roots.put(element.name, element);
        }
        e = dtd.elements.elements();
        while (e.hasMoreElements()) {
            element = (DTDElement)e.nextElement();
            if (!(element.content instanceof DTDContainer)) continue;
            Enumeration items = ((DTDContainer)element.content).getItemsVec().elements();
            while (items.hasMoreElements()) {
                DtdMarshaller.removeElements(roots, dtd, (DTDItem)items.nextElement());
            }
        }
        Collection rootCol = roots.values();
        return rootCol.toArray(new DTDElement[rootCol.size()]);
    }

    protected static void removeElements(Hashtable h, DTD dtd, DTDItem item) {
        if (item instanceof DTDName) {
            h.remove(((DTDName)item).value);
        } else if (item instanceof DTDContainer) {
            Enumeration e = ((DTDContainer)item).getItemsVec().elements();
            while (e.hasMoreElements()) {
                DtdMarshaller.removeElements(h, dtd, (DTDItem)e.nextElement());
            }
        }
    }

    private static final class Element {
        public final DTDElement element;
        public boolean started;

        public Element(DTDElement element, boolean started) {
            this.element = element;
            this.started = started;
        }

        public Element(DTDElement element) {
            this.element = element;
        }

        public String toString() {
            return "[element=" + this.element.getName() + ", started=" + this.started + "]";
        }
    }
}

