/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xml.binding.Content;
import org.jboss.xml.binding.ContentPopulator;
import org.jboss.xml.binding.DelegatingObjectModelFactory;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.ObjectModelBuilder;
import org.jboss.xml.binding.ObjectModelFactory;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Unmarshaller {
    private static final Logger log = Logger.getLogger(Unmarshaller.class);
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    private static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private ObjectModelBuilder builder = new ObjectModelBuilder();
    private XMLReader reader;
    private SAXParser parser;
    private EntityResolver entityResolver;

    public Unmarshaller() throws SAXException, ParserConfigurationException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        this.parser = saxFactory.newSAXParser();
        this.reader = this.parser.getXMLReader();
        this.reader.setContentHandler(new ContentPopulator());
        this.reader.setDTDHandler(new MetaDataDTDHandler());
        this.reader.setErrorHandler(new MetaDataErrorHandler());
        this.setXmlReaderFeature(VALIDATION, true);
        this.setXmlReaderFeature(SCHEMA_VALIDATION, true);
        this.setXmlReaderFeature(SCHEMA_FULL_CHECKING, true);
        this.setXmlReaderFeature(DYNAMIC_VALIDATION, true);
        this.setXmlReaderFeature(NAMESPACES, true);
        this.entityResolver = new JBossEntityResolver();
        this.reader.setEntityResolver(this.entityResolver);
    }

    public void setValidation(boolean validation) throws SAXNotSupportedException, SAXNotRecognizedException {
        this.reader.setFeature(VALIDATION, validation);
    }

    public void setNamespaceAware(boolean namespaces) throws SAXNotSupportedException, SAXNotRecognizedException {
        this.reader.setFeature(NAMESPACES, namespaces);
    }

    public void setXmlReaderFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.reader.setFeature(name, value);
        }
        catch (SAXNotRecognizedException e) {
            log.warn("SAX feature not recognized: " + name);
        }
        catch (SAXNotSupportedException e) {
            log.warn("SAX feature not supported: " + name);
        }
    }

    public void setXmlReaderProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.reader.setProperty(name, value);
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.reader.setDTDHandler(dtdHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.reader.setEntityResolver(entityResolver);
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.reader.setErrorHandler(errorHandler);
    }

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        this.builder.mapFactoryToNamespace(Unmarshaller.getGenericObjectModelFactory(factory), namespaceUri);
    }

    public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws Exception {
        InputSource source = new InputSource(is);
        return this.unmarshal(source, factory, root);
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws Exception {
        InputSource source = new InputSource(reader);
        return this.unmarshal(source, factory, root);
    }

    public Object unmarshal(InputSource source, ObjectModelFactory factory, Object root) throws Exception {
        this.reader.parse(source);
        ContentPopulator populator = (ContentPopulator)this.reader.getContentHandler();
        Content content = populator.getContent();
        return this.builder.build(Unmarshaller.getGenericObjectModelFactory(factory), root, content);
    }

    private static final GenericObjectModelFactory getGenericObjectModelFactory(ObjectModelFactory factory) {
        if (!(factory instanceof GenericObjectModelFactory)) {
            factory = new DelegatingObjectModelFactory(factory);
        }
        return factory instanceof GenericObjectModelFactory ? (GenericObjectModelFactory)factory : new DelegatingObjectModelFactory(factory);
    }

    private static final class MetaDataDTDHandler
    implements DTDHandler {
        private MetaDataDTDHandler() {
        }

        public void notationDecl(String name, String publicId, String systemId) {
            log.debug("notationDecl: name=" + name + ", publicId=" + publicId + ", systemId=" + systemId);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
            log.debug("unparsedEntityDecl: name=" + name + ", publicId=" + publicId + ", systemId=" + systemId + ", notationName=" + notationName);
        }
    }

    private static final class MetaDataErrorHandler
    implements ErrorHandler {
        private MetaDataErrorHandler() {
        }

        public void warning(SAXParseException exception) {
            log.warn(this.formatMessage(exception));
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(this.formatMessage(exception));
        }

        public String formatMessage(SAXParseException exception) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(exception.getMessage()).append(" @ ");
            String location = exception.getPublicId();
            if (location != null) {
                buffer.append(location);
            } else {
                location = exception.getSystemId();
                if (location != null) {
                    buffer.append(location);
                } else {
                    buffer.append("*unknown*");
                }
            }
            buffer.append('[');
            buffer.append(exception.getLineNumber()).append(',');
            buffer.append(exception.getColumnNumber()).append(']');
            return buffer.toString();
        }
    }
}

