/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossEntityResolver
implements EntityResolver {
    private static final Logger log = Logger.getLogger(JBossEntityResolver.class);
    private static Map entities = new ConcurrentReaderHashMap();
    private static boolean warnOnNonFileURLs = false;
    private boolean entityResolved = false;

    public static Map getEntityMap() {
        return Collections.unmodifiableMap(entities);
    }

    public static boolean isWarnOnNonFileURLs() {
        return warnOnNonFileURLs;
    }

    public static void setWarnOnNonFileURLs(boolean warnOnNonFileURLs) {
        JBossEntityResolver.warnOnNonFileURLs = warnOnNonFileURLs;
    }

    public static void registerEntity(String id, String dtdFileName) {
        entities.put(id, dtdFileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.entityResolved = false;
        if (publicId == null && systemId == null) {
            return null;
        }
        boolean trace = log.isTraceEnabled();
        InputSource inputSource = this.resolvePublicID(publicId, trace);
        if (inputSource == null) {
            inputSource = this.resolveSystemID(systemId, trace);
        }
        if (inputSource == null) {
            inputSource = this.resolveClasspathName(systemId, trace);
        }
        if (inputSource == null) {
            inputSource = this.resolveSystemIDasURL(systemId, trace);
        }
        this.entityResolved = inputSource != null;
        return inputSource;
    }

    public boolean isEntityResolved() {
        return this.entityResolved;
    }

    private InputSource resolvePublicID(String publicId, boolean trace) {
        if (publicId == null) {
            return null;
        }
        if (trace) {
            log.trace("resolvePublicID, publicId=" + publicId);
        }
        InputSource inputSource = null;
        String filename = (String)entities.get(publicId);
        if (filename != null) {
            if (trace) {
                log.trace("Found entity from publicId=" + publicId + " fileName=" + filename);
            }
            try {
                InputStream inputStream = this.loadClasspathResource(filename, trace);
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    inputSource.setPublicId(publicId);
                }
            }
            catch (Exception e) {
                log.debug("Cannot load publicId from resource: " + filename, e);
            }
        }
        return inputSource;
    }

    private InputSource resolveSystemID(String systemId, boolean trace) {
        if (systemId == null) {
            return null;
        }
        if (trace) {
            log.trace("resolveSystemID, systemId=" + systemId);
        }
        InputSource inputSource = null;
        String filename = (String)entities.get(systemId);
        if (filename != null) {
            InputStream is;
            if (trace) {
                log.trace("Found entity systemId=" + systemId + " fileName=" + filename);
            }
            if ((is = this.loadClasspathResource(filename, trace)) != null) {
                inputSource = new InputSource(is);
                inputSource.setSystemId(systemId);
            }
        }
        return inputSource;
    }

    private InputSource resolveSystemIDasURL(String systemId, boolean trace) {
        if (systemId == null) {
            return null;
        }
        if (trace) {
            log.trace("resolveSystemIDasURL, systemId=" + systemId);
        }
        InputSource inputSource = null;
        try {
            if (trace) {
                log.trace("Trying to resolve systemId as a URL");
            }
            URL url = new URL(systemId);
            if (warnOnNonFileURLs && !url.getProtocol().equalsIgnoreCase("file")) {
                log.warn("Trying to resolve systemId as a non-file URL: " + systemId);
            }
            InputStream is = url.openStream();
            inputSource = new InputSource(is);
            inputSource.setSystemId(systemId);
            if (trace) {
                log.trace("Resolved systemId as a URL");
            }
        }
        catch (MalformedURLException ignored) {
            if (trace) {
                log.trace("SystemId is not a url: " + systemId, ignored);
            }
        }
        catch (IOException e) {
            log.debug("Failed to obtain URL.InputStream from systemId: " + systemId, e);
        }
        return inputSource;
    }

    private InputSource resolveClasspathName(String systemId, boolean trace) {
        String filename;
        block7: {
            if (systemId == null) {
                return null;
            }
            if (trace) {
                log.trace("resolveClasspathName, systemId=" + systemId);
            }
            filename = systemId;
            try {
                int slash;
                URI url = new URI(systemId);
                String path = url.getPath();
                if (path == null) {
                    path = url.getSchemeSpecificPart();
                }
                filename = (slash = path.lastIndexOf(47)) >= 0 ? path.substring(slash + 1) : path;
                if (trace) {
                    log.trace("Mapped systemId to filename: " + filename);
                }
            }
            catch (URISyntaxException e) {
                if (!trace) break block7;
                log.trace("systemId: is not a URI, using systemId as resource", e);
            }
        }
        InputStream is = this.loadClasspathResource(filename, trace);
        InputSource inputSource = null;
        if (is != null) {
            inputSource = new InputSource(is);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    private InputStream loadClasspathResource(String resource, boolean trace) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(resource);
        if (url == null) {
            if (resource.endsWith(".dtd")) {
                resource = "dtd/" + resource;
            } else if (resource.endsWith(".xsd")) {
                resource = "schema/" + resource;
            }
            url = loader.getResource(resource);
        }
        InputStream inputStream = null;
        if (url != null) {
            if (trace) {
                log.trace(resource + " maps to URL: " + url);
            }
            try {
                inputStream = url.openStream();
            }
            catch (IOException e) {
                log.debug("Failed to open url stream", e);
            }
        }
        return inputStream;
    }

    static {
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", "j2ee_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "application_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd", "application-client_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd", "connector_1_5.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd", "ejb-jar_2_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
        JBossEntityResolver.registerEntity("http://www.w3.org/2001/xml.xsd", "xml.xsd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "application-client_1_3.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3//EN", "jboss-app_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3V2//EN", "jboss-app_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.4//EN", "jboss-app_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS//EN", "jaws.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS 2.4//EN", "jaws_2_4.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS 3.0//EN", "jaws_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 3.0//EN", "jboss_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 3.2//EN", "jboss_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 4.0//EN", "jboss_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN", "jbosscmp-jdbc_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.2//EN", "jbosscmp-jdbc_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.0//EN", "jbosscmp-jdbc_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.3//EN", "jboss-web_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.3V2//EN", "jboss-web_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.4//EN", "jboss-web_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Application Client 3.2//EN", "jboss-client_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Application Client 4.0//EN", "jboss-client_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD MBean Service 3.2//EN", "jboss-service_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD MBean Service 4.0//EN", "jboss-service_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.0//EN", "jboss_xmbean_1_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.1//EN", "jboss_xmbean_1_1.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS XMBEAN 1.2//EN", "jboss_xmbean_1_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS Security Config 3.0//EN", "security_config.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.0//EN", "jboss-ds_1_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.5//EN", "jboss-ds_1_5.dtd");
        JBossEntityResolver.registerEntity("http://www.jboss.org/j2ee/schema/security-config_4_0.xsd", "security-config_4_0.xsd");
        JBossEntityResolver.registerEntity("urn:jboss:bean-deployer", "bean-deployer_1_0.xsd");
        JBossEntityResolver.registerEntity("urn:jboss:security-config:4.1", "security-config_4_1.xsd");
        JBossEntityResolver.registerEntity("urn:jboss:jndi-binding-service:1.0", "jndi-binding-service_1_0.xsd");
        JBossEntityResolver.registerEntity("urn:jboss:user-roles:1.0", "user-roles_1_0.xsd");
        JBossEntityResolver.registerEntity("-//W3C//DTD/XMLSCHEMA 200102//EN", "XMLSchema.dtd");
        JBossEntityResolver.registerEntity("http://www.w3.org/2001/XMLSchema.dtd", "XMLSchema.dtd");
        JBossEntityResolver.registerEntity("datatypes", "datatypes.dtd");
    }
}

