/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.info.plugins.AbstractBeanInfo;
import org.jboss.beans.info.plugins.AbstractPropertyInfo;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.beans.info.spi.EventInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.WeakValueHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanInfoFactory
implements BeanInfoFactory {
    protected Map<ClassLoader, Map<String, BeanInfo>> cache = new WeakHashMap<ClassLoader, Map<String, BeanInfo>>();

    protected static boolean isGetter(MethodInfo minfo) {
        String name = minfo.getName();
        TypeInfo returnType = minfo.getReturnType();
        TypeInfo[] parameters = minfo.getParameterTypes();
        return (name.length() > 3 && name.startsWith("get") || name.length() > 2 && name.startsWith("is")) && parameters.length == 0 && !PrimitiveInfo.VOID.equals(returnType);
    }

    protected static boolean isSetter(MethodInfo minfo) {
        String name = minfo.getName();
        TypeInfo returnType = minfo.getReturnType();
        TypeInfo[] parameters = minfo.getParameterTypes();
        return name.length() > 3 && name.startsWith("set") && parameters.length == 1 && PrimitiveInfo.VOID.equals(returnType);
    }

    protected static String getUpperPropertyName(String name) {
        int start = 3;
        if (name.startsWith("is")) {
            start = 2;
        }
        return name.substring(start);
    }

    protected static String getLowerPropertyName(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        JBossStringBuilder buffer = new JBossStringBuilder(name.length());
        buffer.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            buffer.append(name.substring(1));
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanInfo getBeanInfo(ClassAdapter classAdapter) {
        Map<ClassLoader, Map<String, BeanInfo>> map = this.cache;
        synchronized (map) {
            BeanInfo info;
            ClassLoader cl = classAdapter.getClassLoader();
            ClassInfo classInfo = classAdapter.getClassInfo();
            String className = classInfo.getName();
            WeakValueHashMap map2 = this.cache.get(cl);
            if (map2 != null && (info = map2.get(className)) != null) {
                return info;
            }
            if (classInfo.isInterface()) {
                throw new IllegalArgumentException(classInfo.getName() + " is an interface");
            }
            Set<ConstructorInfo> constructors = this.getConstructors(classInfo);
            Set<MethodInfo> methods = this.getMethods(classInfo);
            Set<PropertyInfo> properties = this.getProperties(methods);
            Set<EventInfo> events = this.getEvents(classInfo);
            BeanInfo result = this.createBeanInfo(classAdapter, properties, constructors, methods, events);
            if (map2 == null) {
                map2 = new WeakValueHashMap();
                this.cache.put(cl, (Map<String, BeanInfo>)map2);
            }
            map2.put(className, result);
            return result;
        }
    }

    protected BeanInfo createBeanInfo(ClassAdapter classAdapter, Set<PropertyInfo> properties, Set<ConstructorInfo> constructors, Set<MethodInfo> methods, Set<EventInfo> events) {
        return new AbstractBeanInfo(this, classAdapter, properties, constructors, methods, events);
    }

    protected Set<ConstructorInfo> getConstructors(ClassInfo classInfo) {
        ConstructorInfo[] cinfos = classInfo.getDeclaredConstructors();
        if (cinfos == null || cinfos.length == 0) {
            return null;
        }
        HashSet<ConstructorInfo> result = new HashSet<ConstructorInfo>();
        for (int i = 0; i < cinfos.length; ++i) {
            result.add(cinfos[i]);
        }
        return result;
    }

    protected Set<MethodInfo> getMethods(ClassInfo classInfo) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] minfos = classInfo.getDeclaredMethods();
            if (minfos != null && minfos.length > 0) {
                for (int i = 0; i < minfos.length; ++i) {
                    if (result.contains(minfos[i])) continue;
                    result.add(minfos[i]);
                }
            }
            classInfo = classInfo.getSuperclass();
        }
        return result;
    }

    protected Set<PropertyInfo> getProperties(Set methods) {
        String lowerName;
        MethodInfo setter;
        String name;
        HashMap<String, MethodInfo> getters = new HashMap<String, MethodInfo>();
        HashMap<String, ArrayList<MethodInfo>> setters = new HashMap<String, ArrayList<MethodInfo>>();
        if (!methods.isEmpty()) {
            for (MethodInfo methodInfo : methods) {
                if (!methodInfo.isPublic() || methodInfo.isStatic()) continue;
                String name2 = methodInfo.getName();
                String upperName = AbstractBeanInfoFactory.getUpperPropertyName(name2);
                if (AbstractBeanInfoFactory.isGetter(methodInfo)) {
                    getters.put(upperName, methodInfo);
                    continue;
                }
                if (!AbstractBeanInfoFactory.isSetter(methodInfo)) continue;
                ArrayList<MethodInfo> list = (ArrayList<MethodInfo>)setters.get(upperName);
                if (list == null) {
                    list = new ArrayList<MethodInfo>();
                    setters.put(upperName, list);
                }
                list.add(methodInfo);
            }
        }
        HashSet<PropertyInfo> properties = new HashSet<PropertyInfo>();
        if (!getters.isEmpty()) {
            for (Map.Entry entry : getters.entrySet()) {
                name = (String)entry.getKey();
                MethodInfo getter = (MethodInfo)entry.getValue();
                setter = null;
                ArrayList setterList = (ArrayList)setters.remove(name);
                if (setterList != null && setterList.size() != 0) {
                    for (int j = 0; j < setterList.size(); ++j) {
                        MethodInfo thisSetter = (MethodInfo)setterList.get(j);
                        TypeInfo pinfo = thisSetter.getParameterTypes()[0];
                        if (!getter.getReturnType().equals(pinfo)) continue;
                        setter = thisSetter;
                        break;
                    }
                }
                lowerName = AbstractBeanInfoFactory.getLowerPropertyName(name);
                properties.add(new AbstractPropertyInfo(lowerName, name, getter.getReturnType(), getter, setter));
            }
        }
        if (!setters.isEmpty()) {
            for (Map.Entry entry : setters.entrySet()) {
                name = (String)entry.getKey();
                ArrayList setterList = (ArrayList)entry.getValue();
                if (setterList.size() != 1) continue;
                setter = (MethodInfo)setterList.get(0);
                TypeInfo pinfo = setter.getParameterTypes()[0];
                lowerName = AbstractBeanInfoFactory.getLowerPropertyName(name);
                properties.add(new AbstractPropertyInfo(lowerName, name, pinfo, null, setter));
            }
        }
        return properties;
    }

    protected Set<EventInfo> getEvents(ClassInfo classInfo) {
        return null;
    }
}

