/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config.plugins.property;

import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.classadapter.spi.DependencyBuilder;
import org.jboss.config.plugins.AbstractConfiguration;
import org.jboss.config.plugins.property.PropertyConfigurationConstants;
import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.repository.spi.MetaDataContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConfiguration
extends AbstractConfiguration {
    private static final Logger log = Logger.getLogger(PropertyConfiguration.class);
    protected Properties properties;

    public PropertyConfiguration() {
        this(null);
    }

    public PropertyConfiguration(Properties properties) {
        if (properties == null) {
            properties = System.getProperties();
        }
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    protected BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable {
        return (BeanInfoFactory)this.loadFromProperties(PropertyConfigurationConstants.BEAN_INFO_FACTORY_NAME, "org.jboss.beans.info.plugins.AbstractBeanInfoFactory", BeanInfoFactory.class);
    }

    @Override
    protected ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable {
        ClassAdapterFactory result = (ClassAdapterFactory)this.loadFromProperties(PropertyConfigurationConstants.CLASS_ADAPTER_FACTORY_NAME, "org.jboss.classadapter.plugins.BasicClassAdapterFactory", ClassAdapterFactory.class);
        result.setConfiguration(this);
        return result;
    }

    @Override
    protected TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable {
        return (TypeInfoFactory)this.loadFromProperties(PropertyConfigurationConstants.TYPE_INFO_FACTORY_NAME, "org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory", TypeInfoFactory.class);
    }

    @Override
    protected JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable {
        return (JoinpointFactoryBuilder)this.loadFromProperties(PropertyConfigurationConstants.JOIN_POINT_FACTORY_BUILDER_NAME, "org.jboss.aop.microcontainer.integration.AOPJoinpointFactoryBuilder:org.jboss.joinpoint.plugins.BasicJoinpointFactoryBuilder", JoinpointFactoryBuilder.class);
    }

    @Override
    protected MetaDataContextFactory createDefaultMetaDataContextFactory() throws Throwable {
        return (MetaDataContextFactory)this.loadFromProperties(PropertyConfigurationConstants.META_DATA_CONTEXT_FACTORY_BUILDER_NAME, "org.jboss.aop.microcontainer.integration.AOPMetaDataContextFactory:org.jboss.repository.plugins.basic.BasicMetaDataContextFactory", MetaDataContextFactory.class);
    }

    @Override
    protected DependencyBuilder createDefaultDependencyBuilder() throws Throwable {
        return (DependencyBuilder)this.loadFromProperties(PropertyConfigurationConstants.DEPENDENCY_BUILDER_NAME, "org.jboss.aop.microcontainer.integration.AOPDependencyBuilder:org.jboss.classadapter.plugins.dependency.AbstractDependencyBuilder", DependencyBuilder.class);
    }

    protected Object loadFromProperties(String propertyName, String defaultValue, Class<? extends Object> targetClass) throws Throwable {
        String value = this.properties.getProperty(propertyName, defaultValue);
        StringTokenizer tokenizer = new StringTokenizer(value, ":");
        Class<?> clazz = null;
        ClassNotFoundException error = null;
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                clazz = this.getClass().getClassLoader().loadClass(className);
                break;
            }
            catch (ClassNotFoundException ignored) {
                log.trace((Object)(className + " not found: " + ignored.getMessage()));
                error = ignored;
            }
        }
        if (clazz == null && error != null) {
            throw error;
        }
        if (clazz == null) {
            throw new RuntimeException("Invalid configuration for property " + propertyName + " expected a class name that implements " + targetClass.getName());
        }
        if (!targetClass.isAssignableFrom(clazz)) {
            throw new RuntimeException("Class " + clazz.getName() + " specified in property " + propertyName + " does not implement " + targetClass.getName());
        }
        return clazz.newInstance();
    }
}

