/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.vfsfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jboss.net.protocol.vfsfile.VirtualFileURLConnection;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class Handler
extends URLStreamHandler {
    protected URLConnection openConnection(URL u) throws IOException {
        File fp;
        String file = u.toString().substring(8);
        File parent = fp = new File(file);
        File curr = fp;
        String relative = fp.getName();
        while ((curr = curr.getParentFile()) != null) {
            parent = curr;
            if (parent.getParentFile() == null) continue;
            relative = parent.getName() + "/" + relative;
        }
        URL url = parent.toURL();
        VFS vfs = VFS.getVFS(url);
        VirtualFile vf = vfs.findChild(relative);
        return new VirtualFileURLConnection(url, vf);
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.protocol.handler.pkgs", "org.jboss.net.protocol");
        URL url = new URL("vfsfile:/c:/tmp/parent.jar/foo.jar/urlstream.java");
        InputStream is = url.openStream();
        while (is.available() != 0) {
            System.out.print((char)is.read());
        }
        is.close();
    }
}

