/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.classloading;

import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import org.jboss.virtual.VFS;
import org.jboss.virtual.classloading.VFSClassLoader;

class SecurityActions {
    static PrivilegedAction<Policy> getPolicyAction = new PrivilegedAction<Policy>(){

        @Override
        public Policy run() {
            return Policy.getPolicy();
        }
    };

    SecurityActions() {
    }

    static VFSClassLoader newClassLoader(String[] paths, VFS vfs) {
        if (System.getSecurityManager() == null) {
            return ClassLoaderActions.NON_PRIVILEGED.newClassLoader(paths, vfs, null);
        }
        return ClassLoaderActions.PRIVILEGED.newClassLoader(paths, vfs, null);
    }

    static VFSClassLoader newClassLoader(String[] paths, VFS vfs, ClassLoader parent) {
        if (System.getSecurityManager() == null) {
            return ClassLoaderActions.NON_PRIVILEGED.newClassLoader(paths, vfs, parent);
        }
        return ClassLoaderActions.PRIVILEGED.newClassLoader(paths, vfs, parent);
    }

    static Policy getPolicy() {
        if (System.getSecurityManager() == null) {
            return ClassLoaderActions.NON_PRIVILEGED.getPolicy();
        }
        return ClassLoaderActions.PRIVILEGED.getPolicy();
    }

    static interface ClassLoaderActions {
        public static final ClassLoaderActions PRIVILEGED = new ClassLoaderActions(){

            public VFSClassLoader newClassLoader(final String[] paths, final VFS vfs, final ClassLoader parent) {
                PrivilegedAction<VFSClassLoader> action = new PrivilegedAction<VFSClassLoader>(){

                    @Override
                    public VFSClassLoader run() {
                        ClassLoader theParent = parent;
                        if (parent == null) {
                            theParent = Thread.currentThread().getContextClassLoader();
                        }
                        return new VFSClassLoader(paths, vfs, theParent);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            public Policy getPolicy() {
                return AccessController.doPrivileged(getPolicyAction);
            }
        };
        public static final ClassLoaderActions NON_PRIVILEGED = new ClassLoaderActions(){

            public VFSClassLoader newClassLoader(String[] paths, VFS vfs, ClassLoader parent) {
                ClassLoader theParent = parent;
                if (parent == null) {
                    theParent = Thread.currentThread().getContextClassLoader();
                }
                return new VFSClassLoader(paths, vfs, theParent);
            }

            public Policy getPolicy() {
                return Policy.getPolicy();
            }
        };

        public VFSClassLoader newClassLoader(String[] var1, VFS var2, ClassLoader var3);

        public Policy getPolicy();
    }
}

