/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public abstract class AbstractURLHandler
extends AbstractVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private final URL url;

    public AbstractURLHandler(VFSContext context, VirtualFileHandler parent, URL url, String name) {
        super(context, parent, name);
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.getURL();
    }

    public long getLastModified() throws IOException {
        this.checkClosed();
        URLConnection c = this.url.openConnection();
        return c.getLastModified();
    }

    public long getSize() throws IOException {
        this.checkClosed();
        URLConnection c = this.url.openConnection();
        return c.getContentLength();
    }

    public boolean isHidden() throws IOException {
        this.checkClosed();
        return false;
    }

    public InputStream openStream() throws IOException {
        this.checkClosed();
        return this.url.openStream();
    }

    public URI toURI() throws URISyntaxException {
        return VFSUtils.toURI(this.url);
    }
}

