/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
import org.jboss.virtual.plugins.context.file.FileSystemContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHandler
extends AbstractURLHandler
implements StructuredVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private transient File file;

    public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URL url) throws IOException {
        super(context, parent, url, file.getName());
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist: " + file.getCanonicalPath());
        }
    }

    public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URI uri) throws IOException {
        this(context, parent, file, uri.toURL());
    }

    @Override
    public FileSystemContext getVFSContext() {
        return (FileSystemContext)super.getVFSContext();
    }

    protected File getFile() {
        this.checkClosed();
        return this.file;
    }

    @Override
    public long getLastModified() {
        return this.getFile().lastModified();
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public boolean isLeaf() {
        return this.getFile().isFile();
    }

    @Override
    public boolean isHidden() {
        return this.getFile().isHidden();
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        File parent = this.getFile();
        File[] files = parent.listFiles();
        if (files == null) {
            throw new IOException("Error listing files: " + parent.getCanonicalPath());
        }
        if (files.length == 0) {
            return Collections.emptyList();
        }
        FileSystemContext context = this.getVFSContext();
        ArrayList<VirtualFileHandler> result = new ArrayList<VirtualFileHandler>();
        for (File file : files) {
            try {
                VirtualFileHandler handler = context.createVirtualFileHandler(this, file);
                result.add(handler);
            }
            catch (IOException e) {
                if (ignoreErrors) {
                    this.log.trace((Object)("Ignored: " + e));
                    continue;
                }
                throw e;
            }
        }
        return result;
    }

    @Override
    public VirtualFileHandler findChild(String path) throws IOException {
        return this.structuredFindChild(path);
    }

    @Override
    public VirtualFileHandler createChildHandler(String name) throws IOException {
        FileSystemContext context = this.getVFSContext();
        File parentFile = this.getFile();
        File child = new File(parentFile, name);
        return context.createVirtualFileHandler(this, child);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.file = new File(this.getURL().getPath());
    }
}

